
/******************************************/
/* The applications in this file were     */
/* designed and coded by Richard Karpen   */
/* University of Washington, Seattle 1998 */
/******************************************/

#include "cs.h"
#include "space.h"
#include <math.h>
static SPACE	*spaceaddr;

#define RESOLUTION 100

void spaceset(SPACE *p)
{

   FUNC *ftp;

   if (*p->ifn > 0)
     if ((ftp = ftfind(p->ifn)) == NULL)
       return;
   p->ftp = ftp;
   
   if (p->auxch.auxp == NULL) {
     float *fltp;
     auxalloc((long)(ksmps * 4)  * sizeof(float), &p->auxch);
     fltp = (float *) p->auxch.auxp;
     p->rrev1 = fltp;   fltp += ksmps; 
     p->rrev2 = fltp;   fltp += ksmps;
     p->rrev3 = fltp;   fltp += ksmps;
     p->rrev4 = fltp;   fltp += ksmps;
   }
    
   spaceaddr=p;
}

void space(SPACE *p)
{
    float	*r1, *r2, *r3, *r4, *sigp, ch1, ch2, ch3, ch4;
    float distance=1.0f, distr, distrsq, direct;
    float *rrev1, *rrev2, *rrev3, *rrev4;
    float torev, localrev, globalrev;
    float	xndx, yndx;
    float half_pi = 0.5f*PI_F;
    float sqrt2 = (float)sqrt(2.0);
    float fabxndx, fabyndx;
    int	nsmps = ksmps;
    FUNC 	*ftp;
    long	indx, length, halflen;
    float 	v1, v2, fract, ndx;
    
    if (*p->ifn > 0) { /* get xy vals from function table */
     if ((ftp = p->ftp) == NULL) {
        initerror("space: not initialized");
        return;
      }
      
      ndx = *p->time * RESOLUTION; /* when data is res. frames/second */
      length = ftp->flen;
      halflen = (long)(length * 0.5f);
      indx = (long) floor(ndx); 
      fract = ndx - indx;
    
      if (ndx > (halflen-1)) {
        indx  = halflen - 1;
        fract = 0.0f;
      }
      else if (ndx < 0) {
        indx  = 0L;
        fract = 0.0f;
      }
    
      v1 = *(ftp->ftable + (indx*2));
      v2 = *(ftp->ftable + (indx*2) + 2);
      xndx = v1 + (v2 - v1) * fract;

      v1 = *(ftp->ftable + (indx*2) + 1);
      v2 = *(ftp->ftable + (indx*2) + 3);
      yndx = v1 + (v2 - v1) * fract;
    }
    else { /* get xy vals from input arguments */
      xndx = *p->kx;
      yndx = *p->ky;
    }

    distance = (float)sqrt((xndx*xndx) + (yndx*yndx)); 
    fabxndx = (float)fabs(xndx);
    fabyndx = (float)fabs(yndx);
    if ((fabxndx > 1.0f) || (fabyndx > 1.0f)) {
      if (fabxndx > fabyndx) {
        xndx = xndx/fabxndx;
        yndx = yndx/fabxndx;
        /* distance = fabxndx; */
      }
      else {
        xndx = xndx/fabyndx;
        yndx = yndx/fabyndx;
        /* distance = fabyndx; */
      }
    }

    if (distance < 1.0f) distance = 1.0f;

    distr=(1.0f / distance);
    distrsq = 1.0f/(float)sqrt(distance); 	

    xndx = (xndx+1)*0.5f;
    yndx = (yndx+1)*0.5f;
	
    ch2 = (float)(sin(half_pi * xndx) * sin(half_pi * yndx) * sqrt2);
    ch4 = (float)(sin(half_pi * xndx) * sin(half_pi * (1-yndx)) * sqrt2);
    ch1 = (float)(sin(half_pi * (1 - xndx)) * sin(half_pi * yndx) * sqrt2);
    ch3 = (float)(sin(half_pi * (1 - xndx)) * sin(half_pi * (1 - yndx)) * sqrt2);

    r1 = p->r1;
    r2 = p->r2;
    r3 = p->r3;
    r4 = p->r4;
    rrev1 = p->rrev1;
    rrev2 = p->rrev2;
    rrev3 = p->rrev3;
    rrev4 = p->rrev4;
    sigp = p->asig;
    do {
      direct = *sigp * distr;
      torev = *sigp * distrsq * *p->reverbamount;
      globalrev = torev * distr;
      localrev = torev * (1 - distr);
      *r1++ = direct * ch1;
      *r2++ = direct * ch2;
      *r3++ = direct * ch3;
      *r4++ = direct * ch4;
      *rrev1++ = (localrev * p->ch1) + globalrev;
      *rrev2++ = (localrev * p->ch2) + globalrev;
      *rrev3++ = (localrev* p->ch3) + globalrev;
      *rrev4++ = (localrev* p->ch4) + globalrev;
      sigp++;
    }
    while (--nsmps);
}


void spsendset(SPSEND *p)
{
	p->space=spaceaddr;
}

void spsend(SPSEND *p)
{
    float	*r1, *r2, *r3, *r4, *rrev1, *rrev2, *rrev3, *rrev4;
    SPACE *q = p->space;
    int	nsmps = ksmps;

    r1 = p->r1;
    r2 = p->r2;
    r3 = p->r3;
    r4 = p->r4;
    rrev1 = q->rrev1;
    rrev2 = q->rrev2;
    rrev3 = q->rrev3;
    rrev4 = q->rrev4;

    do {
      *r1++ = *rrev1++;
      *r2++ = *rrev2++;
      *r3++ = *rrev3++;
      *r4++ = *rrev4++;

    }
    while (--nsmps);
}


void spdistset(SPDIST *p)
{
   FUNC *ftp;

   if (*p->ifn > 0)
     if ((ftp = ftfind(p->ifn)) == NULL)
       return;

   p->ftp = ftp;
   
}

void spdist(SPDIST *p)
{
    float *r;
    float distance, xndx, yndx;
    int	nsmps = ksmps;
    FUNC *ftp;
    long	indx, length, halflen;
    float 	v1, v2, fract, ndx;
	
    r = p->r;

    if (*p->ifn > 0) {
      if ((ftp = p->ftp)==NULL) {
        initerror("spdist: not initialized");
        return;
      }
          
      ndx = *p->time * RESOLUTION; /* when data is 10 frames/second */
      length = ftp->flen;
      halflen = (long)(length * 0.5f);
      indx = (long) floor(ndx); 
      fract = ndx - indx;
    
      if (ndx > (halflen-1)) {
        indx  = halflen - 1;
        fract = 0.0f;
      }
      else if (ndx < 0) {
        indx  = 0L;
        fract = 0.0f;
      }
    
      v1 = *(ftp->ftable + (indx*2));
      v2 = *(ftp->ftable + (indx*2) + 2);
      xndx = v1 + (v2 - v1) * fract;

      v1 = *(ftp->ftable + (indx*2) + 1);
      v2 = *(ftp->ftable + (indx*2) + 3);
      yndx = v1 + (v2 - v1) * fract;
    }
    else { /* get xy vals from input arguments */
      xndx = *p->kx;
      yndx = *p->ky;
    }

    distance = (float)sqrt((xndx*xndx) + (yndx*yndx));
    if (distance < 1.0f) distance = 1.0f;
    *r=distance;
}

