/*      vdelay, multitap, reverb2 coded by Paris Smaragdis 1994 */
/*      Berklee College of Music Csound development team        */
/*      Copyright (c) May 1994.  All rights reserved            */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "cs.h"
#include "vdelay.h"
#include "revsets.h"

#define ESR     (esr/1000.0f)

void vdelset(VDEL *p)           /*  vdelay set-up   */
{
    unsigned long n = (long)(*p->imaxd * ESR);
    float *buf;

    if (n == 0) n = 1;		/* fix due to Troxler */

    if (!*p->istod) {
      if (p->aux.auxp == NULL ||
	  (int)(n*sizeof(float)) > p->aux.size) /* allocate space for delay buffer */
	auxalloc(n * sizeof(float), &p->aux);
      else {
	buf = (float *)p->aux.auxp;  /*    make sure buffer is empty       */
	do {
	  *buf++ = 0.0f;
	} while (--n);
      }
      p->left = 0;
    }
}

void vdelay(VDEL *p)              /*      vdelay  routine */
{
    unsigned long  nn, maxd, indx;
    float *out = p->sr;  /* assign object data to local variables   */
    float *in = p->ain;
    float *del = p->adel;
    float *buf = (float *)p->aux.auxp;

    if (buf==NULL) {            /* RWD fix */
      initerror("vdelay: not initialized");
      return;
    }
    maxd = (unsigned long) (*p->imaxd * ESR);
    if (maxd == 0) maxd = 1;	/* Degenerate case */
    nn = ksmps;
    indx = p->left;

    if (p->XINCODE == 3)    {    /*      if delay is a-rate      */
        do {
	    float  fv1, fv2;
	    long   v1, v2;
        
            buf[indx] = *in++;
            fv1 = indx - (*del++) * ESR;
        /* Make sure Inside the buffer      */
	    /*
	     * The following has been fixed by adding a cast and making a
	     * ">=" instead of a ">" comparison. The order of the comparisons
	     * has been swapped as well (a bit of a nit, but comparing a
	     * possibly negative number to an unsigned isn't a good idea--and
	     * broke on Alpha).
	     * heh 981101
	     */
            while (fv1 < 0.0f)
                fv1 += (float)maxd;
            while (fv1 >= (float)maxd)
                fv1 -= (float)maxd;
        
            if (fv1 < maxd - 1) /* Find next sample for interpolation      */
                fv2 = fv1 + 1;
            else
                fv2 = 0.0f;
        
            v1 = (long)fv1;
            v2 = (long)fv2;
            *out++ = buf[v1] + (fv1 - ( long)fv1) * ( buf[v2] - buf[v1]);
        
            if (++indx == maxd) indx = 0;             /* Advance current pointer */

        } while (--nn);
    }
    else {                      /* and, if delay is k-rate */
        do {
            float  fv1, fv2;
            long   v1, v2;
        
            buf[indx] = *in++;
            fv1 = indx - *del * ESR;
				/* Make sure inside the buffer      */
	    /*
	     * See comment above--same fix applied here.  heh 981101
	     */
            while (fv1 < 0.0f)
                fv1 += (float)maxd;
            while (fv1 >= (float)maxd)
                fv1 -= (float)maxd;
        
            if (fv1 < maxd - 1) /* Find next sample for interpolation      */
                fv2 = fv1 + 1;
            else
                fv2 = 0.0f;
        
            v1 = (long)fv1;
            v2 = (long)fv2;
            *out++ = buf[v1] + (fv1 - ( long)fv1) * ( buf[v2] - buf[v1]);
        
            if (++indx == maxd) indx = 0;             /*      Advance current pointer */
                        
        } while (--nn);
    }
    p->left = indx;             /*      and keep track of where you are */
}

void vdelay3(VDEL *p)              /*      vdelay routine with cubic interp */
{
    unsigned long  nn, maxd, indx;
    float *out = p->sr;  /* assign object data to local variables   */
    float *in = p->ain;
    float *del = p->adel;
    float *buf = (float *)p->aux.auxp;

    if (buf==NULL) {            /* RWD fix */
      initerror("vdelay3: not initialized");
      return;
    }
    maxd = (unsigned long) (*p->imaxd * ESR);
    if (maxd == 0) maxd = 1;	/* Degenerate case */
    nn = ksmps;
    indx = p->left;

    if (p->XINCODE == 3)    {    /*      if delay is a-rate      */
        do {
	    float  fv1, fv2;
	    long   v0, v1, v2, v3;
        
            buf[indx] = *in++;
            fv1 = indx - (*del++) * ESR;
        /* Make sure Inside the buffer      */
	    /*
	     * The following has been fixed by adding a cast and making a
	     * ">=" instead of a ">" comparison. The order of the comparisons
	     * has been swapped as well (a bit of a nit, but comparing a
	     * possibly negative number to an unsigned isn't a good idea--and
	     * broke on Alpha).
	     * heh 981101
	     */
            while (fv1 < 0.0f)
                fv1 += (float)maxd;
            while (fv1 >= (float)maxd)
                fv1 -= (float)maxd;
        
            if (fv1 < maxd - 1) /* Find next sample for interpolation      */
                fv2 = fv1 + 1;
            else
                fv2 = 0.0f;

            v1 = (long)fv1;
            v2 = (long)fv2;
            if (maxd<4) {
            *out++ = buf[v1] + (fv1 - ( long)fv1) * ( buf[v2] - buf[v1]);
            }
            else {
              float delfrac = fv1 - ( long)fv1;
              v0 = (v1==0 ? maxd-1 : v1-1);
              v3 = (v2==(long)maxd-1 ? 0 : v2+1);
              {
                float frsq = delfrac*delfrac;
                float frcu = frsq*buf[v0];
                float t1 = buf[v3] + 3*buf[v1];
                *out++ = buf[v1] + 0.5f*frcu +
                  delfrac*(buf[v2] - frcu/6 - t1/6 - buf[v0]/3) +
                  frsq*delfrac*(t1/6 - 0.5f*buf[v2]) +
                  frsq*(0.5f* buf[v2] - buf[v1]);
              }
            }
            if (++indx == maxd) indx = 0;             /* Advance current pointer */

        } while (--nn);
    }
    else {                      /* and, if delay is k-rate */
        do {
            float  fv1, fv2;
	    long   v0, v1, v2, v3;
        
            buf[indx] = *in++;
            fv1 = indx - *del * ESR;
				/* Make sure inside the buffer      */
	    /*
	     * See comment above--same fix applied here.  heh 981101
	     */
            while (fv1 < 0.0f)
                fv1 += (float)maxd;
            while (fv1 >= (float)maxd)
                fv1 -= (float)maxd;
        
            if (fv1 < maxd - 1) /* Find next sample for interpolation      */
                fv2 = fv1 + 1;
            else
                fv2 = 0.0f;
        
            v1 = (long)fv1;
            v2 = (long)fv2;
            if (maxd<4) {
            *out++ = buf[v1] + (fv1 - ( long)fv1) * ( buf[v2] - buf[v1]);
            }
            else {
              float delfrac = fv1 - ( long)fv1;
              v0 = (v1==0 ? maxd : v1-1);
              v3 = (v2==(long)maxd-1 ? 0 : v2+1);
              {
                float frsq = delfrac*delfrac;
                float frcu = frsq*buf[v0];
                float t1 = buf[v3] + 3*buf[v1];
                *out++ = buf[v1] + 0.5f*frcu +
                  delfrac*(buf[v2] - frcu/6 - t1/6 - buf[v0]/3) +
                  frsq*delfrac*(t1/6 - 0.5f*buf[v2]) +
                  frsq*(0.5f* buf[v2] - buf[v1]);
              }
            }
            if (++indx == maxd) indx = 0;             /*      Advance current pointer */
                        
        } while (--nn);
    }
    p->left = indx;             /*      and keep track of where you are */
}

void multitap_set(MDEL *p)
{
    long n;
    float *buf, max = 0.0f;

    if (p->INOCOUNT/2 == (float)p->INOCOUNT/2.)
        die("Wrong input count in multitap\n");

    for (n = 0 ; n < p->INOCOUNT - 1 ; n += 2) {
        if (max < *p->ndel[n]) max = *p->ndel[n];
    }

    n = (long)(esr * max * sizeof(float));
    if (p->aux.auxp == NULL ||    /* allocate space for delay buffer */
	n > p->aux.size)
      auxalloc(n, &p->aux);
    else {
      buf = (float *)p->aux.auxp; /* make sure buffer is empty       */
      n = p->max;
      do {
	*buf++ = 0.0f;
      } while (--n);
    }

    p->left = 0;
    p->max = (long)(esr * max);
}

void multitap_play(MDEL *p)
{                               /* assign object data to local variables   */
    long  n, nn = ksmps, indx = p->left, delay;
    float *out = p->sr, *in = p->ain;
    float *buf = (float *)p->aux.auxp;
    float max = (float)p->max;

    if (buf==NULL) {            /* RWD fix */
      initerror("multitap: not initialized");
      return;
    }
    do {
        buf[indx] = *in++;      /*      Write input     */
        *out = 0.0f;            /*      Clear output buffer     */

        if (++indx == max) indx = 0;         /*      Advance input pointer   */
        for (n = 0 ; n < p->INOCOUNT - 1 ; n += 2) {
            delay = indx - (long)(esr * *p->ndel[n]);
            if (delay < 0)
                delay += (long)max;
            *out += buf[delay] * *p->ndel[n+1]; /*      Write output    */
        }
        out++;                  /*      Advance output pointer  */
    } while (--nn);
    p->left = indx;
}

#ifdef OLD_CODE
#define LOG001  (-6.9078)       /* log(.001) */

void reverb2_set(STVB *p)            /* 6-comb/lowpass, 5-allpass reverberator */
{
     long i, n;
     float *temp;

    if (*p->hdif > 1.0 || *p->hdif < 0)
        die("High frequency diffusion not in (0, 1)\n");

    if (*p->istor == 0.0 || p->temp.auxp == NULL) {
      auxalloc(ksmps * sizeof(float), &p->temp);
      temp = (float *)p->temp.auxp;
      for (n = 0 ; n < ksmps ; n++)
        *temp++ = 0.0;
      for (i = 0 ; i < Combs ; i++) {
        p->c_time[i] = gc_time[i];
        p->c_gain[i] = exp((double)(LOG001 * (p->c_time[i]/esr) /
                                    (gc_gain[i] * *p->time)));
        p->g[i] = *p->hdif;
        p->c_gain[i] = p->c_gain[i] * (1 - p->g[i]);
        p->z[i] = 0.0;

        auxalloc((long)(p->c_time[i] * sizeof(float)), &p->caux[i]);
        p->cbuf_cur[i] = (float *)p->caux[i].auxp;
        for (n = 0 ; n < p->c_time[i] ; n++)
            *(p->cbuf_cur[i] + n) = 0.0;
      }

      for (i = 0 ; i < Alpas ; i++) {
        p->a_time[i] = ga_time[i];
        p->a_gain[i] = exp((double)(LOG001 * (p->c_time[i]/esr) /
                                    (ga_gain[i] * *p->time)));
        auxalloc((long) p->a_time[i] * sizeof(float), &p->aaux[i]);
        p->abuf_cur[i] = (float *)p->aaux[i].auxp;
      }
    }

    p->prev_time = *p->time;
    p->prev_hdif = *p->hdif;
}

void reverb2_play(STVB *p)
{
    long       i, n = ksmps;
     float      *in, *out = p->out, *buf, *end;
     float      gain, z;

     if (p->temp.auxp==NULL) {
       initerror("reverb2: not initialized");
       return;
     }
     do  *out++ = 0.0;
     while (--n);
     if (*p->time != p->prev_time || *p->hdif != p->prev_hdif) {
       if (*p->hdif > 1.) {
         printf("Warning: High frequency diffusion>1\n");
         *p->hdif = 1.;
       }
       if (*p->hdif < 0)       {
         printf("Warning: High frequency diffusion<0\n");
         *p->hdif = 0.;
       }
       if (*p->time < 0)       {
         printf("Negative time?\n");
         *p->time = 0.0;
       }
       for (i = 0 ; i < Combs ; i++)   {
         p->c_gain[i] = exp((double)(LOG001 * (p->c_time[i]/esr) /
                                     (gc_gain[i] * *p->time)));
         p->g[i] = *p->hdif;
         p->c_gain[i] = p->c_gain[i] * (1 - p->g[i]);
         p->z[i] = 0.0;
       }

       for (i = 0 ; i < Alpas ; i++)
         p->a_gain[i] = exp((double)(LOG001 * (p->a_time[i]/esr) /
                                     (ga_gain[i] * *p->time)));

       p->prev_time = *p->time;
       p->prev_hdif = *p->hdif;
     }

     for (i = 0 ; i < Combs ; i++)       {
       buf = p->cbuf_cur[i];
       end = (float *)p->caux[i].endp;
       gain = p->c_gain[i];
       in = p->in;
       out = p->out;
       n = ksmps;
       do {
         *out++ += *buf;
         *buf += p->z[i] * p->g[i];
         p->z[i] = *buf;
         *buf *= gain;       
         *buf += *in++;                      
         if (++buf >= end)
           buf = (float *)p->caux[i].auxp;
       } while (--n);
       p->cbuf_cur[i] = buf;
     }

     for (i = 0 ; i < Alpas ; i++)       {
       in = (float *)p->temp.auxp;
       out = p->out;
       n = ksmps;
       do      *in++ = *out++;
       while (--n);
       buf = p->abuf_cur[i];
       end = (float *)p->aaux[i].endp;
       gain = p->a_gain[i];
       in = (float *)p->temp.auxp;
       out = p->out;
       n = ksmps;
       do {
         z = *buf;
         *buf = gain * z + *in++;
         *out++ = z - gain * *buf;
         if (++buf >= end)
           buf = (float *)p->aaux[i].auxp;
       } while (--n);
       p->abuf_cur[i] = buf;
     }
}
#endif

/*      nreverb coded by Paris Smaragdis 1994 and Richard Karpen 1998 */

#include "nreverb.h"

#define LOG001  (-6.9078)       /* log(.001) */
#define true 1
#define false 0

float ngc_time[Combs] = {1433.0f, 1601.0f, 1867.0f, 2053.0f, 2251.0f, 2399.0f};
float ngc_gain[Combs] = {.822f, .802f, .773f, .753f, .753f, .753f};
float nga_time[Alpas] = {347.0f, 113.0f, 37.0f, 59.0f, 43.0f};
float nga_gain = 0.7f;

int prime( int val )
{
    int i, last;
	
    last = (int)sqrt( (double)val );
    for ( i = 3; i <= last; i+=2 ) {
      if ( (val % i) == 0 ) return false;
    }
    return true;
}

void nreverb_set(NREV *p)   /* 6-comb/lowpass, 5-allpass reverberator */
{
     long i, n;
     float *temp;
     float srscale=esr/25641.0f; /* denominator is probably CCRMA "samson box" sampling-rate! */
     int c_time, a_time;

     if (*p->hdif > 1.0f || *p->hdif < 0.0f)
        die("High frequency diffusion not in (0, 1)\n");
     
     if (*p->istor == 0.0f || p->temp.auxp == NULL) {
       auxalloc(ksmps * sizeof(float), &p->temp);
       temp = (float *)p->temp.auxp;
       for (n = 0 ; n < ksmps ; n++)
         *temp++ = 0.0f;
 
       for (i = 0 ; i < Combs ; i++) {
       /* derive new primes to make delay times work with orch. sampling-rate */ 
         c_time = (int)(ngc_time[i] * srscale);
         if (c_time % 2 == 0)  c_time += 1;
         while(!prime( c_time))  c_time += 2;
         p->c_time[i] = (float)c_time;

         p->c_gain[i] = (float)exp((double)(LOG001 * (p->c_time[i]/esr) /
					    (ngc_gain[i] * *p->time)));
         p->g[i] = *p->hdif;
         p->c_gain[i] = p->c_gain[i] * (1 - p->g[i]);
         p->z[i] = 0.0f;

         auxalloc((long)(p->c_time[i] * sizeof(float)), &p->caux[i]);
         p->cbuf_cur[i] = (float *)p->caux[i].auxp;
         for (n = 0 ; n < p->c_time[i] ; n++)
           *(p->cbuf_cur[i] + n) = 0.0f;
       }
       for (i = 0 ; i < 5 ; i++) {
         a_time = (int)(nga_time[i] * srscale);
         if (a_time % 2 == 0)  a_time += 1;
         while(!prime( a_time))  a_time += 2;
         p->a_time[i] = (float)a_time;
         p->a_gain[i] = (float)exp((double)(LOG001 * (p->a_time[i]/esr) /
					    (nga_gain * *p->time))); 
         auxalloc((long) p->a_time[i] * sizeof(float), &p->aaux[i]);
         p->abuf_cur[i] = (float *)p->aaux[i].auxp;
       }
        
     }

     p->prev_time = *p->time;
     p->prev_hdif = *p->hdif;
}

void nreverb(NREV *p)
{
    long       i, n = ksmps;
    float      *in, *out = p->out, *buf, *end;
    float      gain, z;

    if (p->temp.auxp==NULL) {
      initerror("reverb2: not initialized");
      return;
    }
    do  *out++ = 0.0f;
    while (--n);
    if (*p->time != p->prev_time || *p->hdif != p->prev_hdif) {
      if (*p->hdif > 1.0f) {
        printf("Warning: High frequency diffusion>1\n");
        *p->hdif = 1.0f;
      }
      if (*p->hdif < 0.0f)       {
        printf("Warning: High frequency diffusion<0\n");
        *p->hdif = 0.0f;
      }
      if (*p->time < 0.0f)       {
        printf("Negative time?\n");
        *p->time = 0.0f;
      }
      for (i = 0 ; i < Combs ; i++)   {
        p->c_gain[i] = (float)exp((double)(LOG001 * (p->c_time[i]/esr) /
					   (ngc_gain[i] * *p->time)));
        p->g[i] = *p->hdif;
        p->c_gain[i] = p->c_gain[i] * (1 - p->g[i]);
        p->z[i] = 0.0f;
      }

      for (i = 0 ; i < Alpas ; i++)
        p->a_gain[i] = (float)exp((double)(LOG001 * (p->a_time[i]/esr) /
					   (nga_gain * *p->time)));

      p->prev_time = *p->time;
      p->prev_hdif = *p->hdif;
    }

    for (i = 0 ; i < Combs ; i++)       {
      buf = p->cbuf_cur[i];
      end = (float *)p->caux[i].endp;
      gain = p->c_gain[i];
      in = p->in;
      out = p->out;
      n = ksmps;
      do {
        *out++ += *buf;
        *buf += p->z[i] * p->g[i];
        p->z[i] = *buf;
        *buf *= gain;       
        *buf += *in++;                      
        if (++buf >= end)
          buf = (float *)p->caux[i].auxp;
      } while (--n);
      p->cbuf_cur[i] = buf;
    }

    for (i = 0 ; i < 5 ; i++)       {
      in = (float *)p->temp.auxp;
      out = p->out;
      n = ksmps;
      do      *in++ = *out++;
      while (--n);
      buf = p->abuf_cur[i];
      end = (float *)p->aaux[i].endp;
      gain = p->a_gain[i];
      in = (float *)p->temp.auxp;
      out = p->out;
      n = ksmps;
      do {
        z = *buf;
        *buf = gain * z + *in++;
        *out++ = z - gain * *buf;
        if (++buf >= end)
          buf = (float *)p->aaux[i].auxp;
      } while (--n);
      p->abuf_cur[i] = buf;
    }
}
