.TH gk_newenv n "29 May 1995" "GroupKit"
.SH NAME
gk_newenv \- create and manipulate shared data
.SH SYNOPSIS
\fBgk_newenv \fI?-notify? ?-share? ?-client? ?-server? ?-bind? ?-serialize? envName\fR
.SH DESCRIPTION
Environments serve to hold pieces of related information within
a single data structure, and optionally share that data between
different processes.  Environments are hierarchically structured
dictionaries.  Information in an environment is accessed via a key,
which specifies where within the environment information is stored.
Because environments are hierarchical, keys serve to encode this
hierarchy.  Keys use a period (".") as the hierarchy delimeter.
For example, the key "local" refers to information at the
first level of the hierarchy, whereas the key "local.name" refers
to information deeper in the hierarchy.

Environments are created with the \fBgk_newenv\fR command, which
specifies a name for the environment.  This creates an 
\fIenvironment command\fR, similar to Tk's widget commands, which
is used to manipulate the environment.

The behavior of environments can also be manipulated by the
application program, so that a particular instance of an environment
may act radically different from what is described here.  The
section on customizing environments explains this.

.SH ENVIRONMENT COMMAND

The \fBgk_newenv\fR command creates a new Tcl command whose name is
\fIenvName\fR.  This command may be used to invoke various operations
on the environment.  It has the following general form:
.PP
.RS 5
\fIenvName option ?arg arg ...?\fR
.PP
.RE
The following subcommands are defined for standard environments:

.TP
\fIenvName\fB set\fI key value\fR
Store information specified by \fIvalue\fR into the environment at 
\fIkey\fR.  \fIvalue\fR should represent only simple data; use
the \fBimport\fR subcommand to insert a tree of information.  In the
case where \fIkey\fR does not specify any other subcommand defined
for the environment, the keyword \fBset\fR may be omitted.

.TP
\fIenvName \fBget \fIkey\fR
Retrieve the information stored in the environment at \fIkey\fR.
If \fIkey\fR represents a hierarchy of information, it is returned
as a keyed list.  If the \fIkey\fR does not exist in the environment,
an empty string is returned.  In the case where \fIkey\fR does not specify 
any other subcommand defined for the environment, the keyword \fBget\fR
may be omitted.  

.TP
\fIenvName\fB keys \fI?basekey?\fR
Display the names of the keys directly underneath \fIbasekey\fR in the 
environment.  If \fIbasekey\fR is omitted, display the names of
the keys at the root level of the environment.

.TP
\fIenvName\fB delete \fIkey\fR
Delete the information contained within \fIkey\fR.  Deleting a key
which itself is a parent of other keys deletes all the information
in the hierarchy.

.TP
\fIenvName\fB exists \fIkey\fR
Determine if \fIkey\fR exists in the environment.  Returns 1 if
\fIkey\fR exists, 0 otherwise.

.TP
\fIenvName\fB import \fIbasekey data\fR
Import a collection of information, specified as the keyed list
\fIdata\R, into the environment underneath the key \fIbasekey\fR.
Note that \fIdata\fR is passed by value, not by reference, which
differs from most of the standard commands for manipulating keyed lists.

.TP
\fIenvName\fB destroy\fR
Destroy the environment, its associated data, and the environment
command.

.TP
\fIenvName\fB debug\fR
Display the contents of the environment on stdout, for debugging
purposes.

.TP
\fIenvName\fB option \fIargs...\fR
Store option information in the environment.  Essentially, this 
command allows access to a separate space within the environment
designed for storing information about the environment's behavior,
as described in the section below on customization.  The option
space works similarly to the conventional data space.  The \fBoption\fR
subcommand has the following forms:
.IP
.nf
  \fIenvName \fBoption set \fIkey value\fR
  \fIenvName \fBoption get \fIkey\fR
  \fIenvName \fBoption delete \fIkey\fR
  \fIenvName \fBoption keys \fR?\fIkey\fR?
.fi
.LP

.TP
\fIenvName\fB command \fIargs...\fR
This subcommand is used to modify the behavior of the environment, 
by manipulating the environment command's subcommands.  Its use is
described in detail below, in the section on customizing environments.

.SH ENVIRONMENT EVENTS

If the \fI-notify\fR switch is specified when an environment is created
with \fBgk_newenv\fR, the environment will generate events whenever its
contents are modified.  This provides a convenient way for you to
model information; changes in the environment (the model) can 
generate events which will then propagate to change
your interface (the view).

Environments will generate three types of events: \fBaddEnvInfo\fR (when new
information is added to an environment), \fBchangeEnvInfo\fR (when
existing information in an environment is changed), and
\fBdeleteEnvInfo\fR (when information in an environment is deleted).
In addition to the event \fBtype\fR attribute, each of these events
also contains an \fBenv\fR attribute giving the name of the environment
where the change occurred, and a \fBkey\fR attribute describing where
within the environment the change occurred.

Alternately, events may be generated using a different mechanism,
more analogous to Tk's bind command.  If \fI-bind\fR is specified
rather than \fI-notify\fR, the events will be generated using the
notification mechanism described in gk_notifier(n).  In that case, the
following subcommands are available in the environment:
.TP
\fIenvName \fBbind \fIevent command\fR
Arrange for \fIcommand\fR to be executed when an event having the type
specified in \fIevent\fR (e.g. addEnvInfo) is generated.  If the 
string "%K" appears in \fIcommand\fR, it will be replaced with the
key attribute of the event.  This command returns a token which can be
used to remove the binding.

.TP
\fIenvName \fBdelbind \fIbinding\fR
Remove an event binding, where \fIbinding\fR is the token returned
when the binding was first created.

.SH SHARED ENVIRONMENTS

If the \fI-share\fR switch is specified when an environment is created,
the environment will be shared between GroupKit conference processes.
The sharing supported by this form of environments does not support
any form of concurrency control; it is quite possible for copies of
the environment on two different processes to get out of sync.  This
may in fact not be a bad thing for certain applications, and certainly
reduces the overhead and delays inherent in keeping data correctly
synchronized.

This version of environments uses the following mechanism for sharing.
Whenever a change is made to an environment in any of the conference
processes, that change is broadcast to all copies of the environment,
via a gk_toAll(n) call.  This can lead to race conditions.  For example,
if process A changes the value X to 3, at the same time process B
changes X to 5, the following can occur.  Each process will execute the
change locally (leaving X at 3 on process A and at 5 on process B), and
then send the change to the other process.  The end result will be
that X has the value 5 on process A, and the value 3 on process B.

Sharing becomes quite useful when combined with notification.  If both
\fI-share\fR and \fI-notify\fR (or \fI-bind\fR) are specified, events
will be generated whenever the environment changes, whether the change
was initiated by the local user or a remote process.  Applications can
take advantage of this by tying their display to events generated by
the underlying environment which is used to model the abstract application
data.

Shared environments generate one additonal event, \fBenvReceived\R.  When
a new user joins an existing GroupKit session, one of the existing
users is chosen (via the updateEntrant mechanism) to send a copy of the
data already existing in the environment to the newcomer.  On the
receiving end, this will generate an \fBenvReceived\fR event.  The
application will typically need to traverse the environment, for example
to create objects on the display that mirror those in the environment.

.SH CENTRAL SERIALIZED CONCURRENCY CONTROL

A version of shared environments are available for cases where a 
centralized process is available to manage concurrency control.
These environments are therefore not suitable for use in GroupKit
conferences, where no such process exists.  They are used however
by GroupKit's registration system, as well as the rooms based
registration client.

The environment must first be created on the centralized process.
This environment is created using the \fI-server\fR option.

Environments that connect up to the centralized process are referred
to as client environments, and are created using the \fI-client\fR
option.  After creation, they must then be "attached" to the 
centralized server process using the following command.

.TP
\fIenvName \fBserver \fIfd\fR
Connect to the centralized server environment, where \fIfd\fR specifies
the file descriptor used to send messages to the server process.
.LP
Serialized environments work by sending all changes through the
centralized process, which then redistributes them to all clients.
In this way, changes arrive in the same order on all processes.
However, there can be a substantial time delay between when a change
is made locally to the environment, and when it takes effect, after
the round trip to the centralized server process.

.SH CONFERENCE SERIALIZED CONCURRENCY CONTROL

The final variation on environments is used to provide a serialized
concurrency control implementation (as used in the centralized process
version described above), but within GroupKit conferences.  In this
case, one of the users in the conference is chosen as the "central"
processes to centralize changes through.  This "centralized process"
may change as users enter and leave the conference.  To use this
form of concurrency control, the \fI-serialize\fR option is used when
creating the environment.  This may also of course be combined with
\fI-notify\fR or \fI-bind\fR, but not with \fI-share\fR, \fI-server\fR,
or \fI-client\fR.

.SH CUSTOMIZING ENVIRONMENTS

It is possible to customize the behavior of environments, by modifying
the subcommands available to the environment.  More detail and rationale
are described in the paper "When is an object not an object?".

The following environment subcommands are available for customizing
environments.

.TP
\fIenvName \fBcommand set \fIcmdname script\fR
Specify that \fIscript\fR is to be invoked whenever a command of the form
\fIenvName cmdname args...\fR is executed.

.TP
\fIenvName \fBcommand get \fIcmdname\fR
Return the script that is to invoked whenever the subcommand \fIcmdname\fR
is executed in the environment.  For subcommands not having a Tcl script
associated with them (i.e. they are handled by C code), the string
"<builtin>" is returned.

.TP
\fIenvName \fBcommand delete \fIcmdname\fR
Remove any handler associated with the subcommand \fIcmdname\fR, 
making the subcommand invalid.

.TP
\fIenvName \fBcommand list\fR
Return the list of valid subcommands for the environment.

.TP
\fIenvName \fBcommand rename \fIoldname newname\fR
Associate the handler currently attached to \fIoldname\fR with the
subcommand specified by \fInewname\fR.  The \fIoldname\fR subcommand
is still available with the same handler.

.SH "SEE ALSO"
.PP
gk_event(n), gk_notifier(n), gk_runtime(n)

Roseman, M. "When is an object not an object?"  Proceedings of the 1995
Tcl Workshop.


.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
