.TH gk_scrollbar n "5 May 1995" "GroupKit"
.SH NAME
gk_scrollbar \- Create a multi-user scrollbar
.SH SYNOPSIS
.TP 
\fBgk_scrollbar\fI pathname \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBactiveForeground	highlightBackground	jump	takeFocus
\fBactiveRelief	highlightColor	orient	troughColor
\fBbackground	highlightThickness	relief	xScrollCommand
\fBborderWidth	insertBackground	repeatDelay	yScrollCommmand
\fBcommand	insertBorderWidth	repeatInterval	width
\fBcursor	insertOffTime	selectBackground	
\fBelementBorderwidth	insertOnTime	selectBorderWidth
\fBforeground	insertWidth	selectForeground
.VE
.fi

See the ``options'', ``canvas'', and ``scrollbar'' manual entries for 
details on the standard options. 
The default method for applying the standard options, is too apply them
to either the local or remote scrollbars.  If both of these cause an
error then an error occurs.

.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBbarWidth\fR
Class:	\fBBarWidth\fR
Command-Line Switch:	\fB\-barwidth\fR
.fi
.IP
Specifies the width of the display (non-manipulatable) area of the
group scrollbar.
.LP

.ta 4c
.nf
Name:	\fBcolor\fR
Class:	\fBColor\fR
Command-Line Switch:	\fB\-color\fR
.fi
.IP
Specifies the color of the local users scrollbar on the remote portion
of the group scrollbar.  Any valid Tk color may be used.  The default
value is chosen by gk_getMyColour.
.LP

.ta 4c
.nf
Name:	\fBmultiUser\fR
Class:	\fBMultiUser\fR
Command-Line Switch:	\fB\-multiuser\fR
.fi
.IP
Specifies whether or not the multi-user (remote) scrollbar is shown.  
If true then there is a  multi-user scrollbar; if false then there is not.
Any Tk boolean value is valid and the default value is true.
.LP

.ta 4c
.nf
Name:	\fBscrollid\fR
Class:	\fBScrollId\fR
Command-Line Switch:	\fB\-scrollid\fR
.fi
.IP
Specifies the scrollid for the scrollbar; scrollbars attached to different
parts of the application should have a different scrollid.  The default
is ``gkGroupScroll''.  It is possible to have both vertical scrollbar 
and a horizontal scrollbar within an application without side
effects, although they will be sharing information.
.LP

.SH DESCRIPTION
This widget combines a conventional Tk scrollbar with a display area,
which shows the scrollbar positions of any number of users.  When users
manipulate their own scrollbars, their position in the document is
displayed in this area on all users' screens.

.SH "WIDGET COMMAND"
The \fBgk_scrollbar\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  Since the group scroll bar inherits subcommands from both
the Tk canvas widget and the Tk scrollbar, all of these subcommands can
be used with this widget.  See the appropriate manual entries for more
information.  In addition to these subcommands the  following commands 
are possible for gk_scrollbar widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_scrollbar\fR
command.
.TP
\fIpathName \fBcomponent local\fR
Return the path name of the local user's Tk scrollbar
about the program.
.TP
\fIpathName \fBcomponent remote\fR
Return the path name of the canvas widget used to represent the 
non-manipulatable display area.
.TP
\fIpathName \fBset \fIfirst last\fR
Set the scrollbar to display the indicated view area.  \fIfirst\fR and
\fIlast\fR are floating point values between 0.0 and 1.0.

.SH "DEFAULT BINDINGS"
Mouse button 1 in the display area will display the name of the user
associated with a particular bar.  The Tk scrollbar retains its
normal bindings.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.

.SH ``SEE ALSO''
classBuilder(n)

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
