.TH gk_toAll n "8 Dec 1994" "GroupKit"
.SH NAME
gk_toAll, gk_toOthers, gk_toUserNum, gk_RPCtoUserNum, gk_serialize \- 
send messages between conferences
.SH DESCRIPTION
These commands provide a way to execute commands on a variety of
workstations in a GroupKit conference.  
.TP
\fBgk_toAll \fIcommand\fR
arranges for \fIcommand\fR to be executed by all users in a GroupKit
session,  including the local user.
.TP
\fBgk_toOthers \fIcommand\fR
executes \fIcommand\fR on all remote users' workstations,
but not the local workstation.
.TP
\fBgk_serialize \fIcommand\fR
executes \fIcommand\fR on all users' workstations.  This command
is used to ensure that a sequence of commands are executed in the
same order on all users' workstations.  This is accomplished by
serializing the commands through a single conference process.
.TP
\fBgk_toUserNum \fIusernum command\fR
executes \fIcommand\fR only on the workstation of
the user identified by \fIusernum\fR, which may be either a remote
user or the local user.
.TP
\fBgk_RPCtoUserNum \fIusernum command\fR
executes \fIcommand\fR on the workstation of the user identified by
\fIusernum\fR, and returns the result of executing that command.
Because the program will block until a result is received from the
remote user, this can lead to extremely unresponsive programs.  This
construct should be used extremely sparingly; there are always better
ways to do what you're probably trying to do by using it.
.SH "SEE ALSO"
.PP
dp_rpc(n), gk_server(n)
.SH NOTE
In the future, these commands will function not only with conferences,
but with registrar clients (or in fact, any GroupKit client/server setup).
.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
