/**
 *
 * $Id: FileSB.c,v 1.25 1996/04/22 22:54:50 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: FileSB.c,v 1.25 1996/04/22 22:54:50 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/List.h>
#include <Xm/SelectioBP.h>
#include <Xm/FileSBP.h>
#include <Xm/XmosP.h>
#include <Xm/TextF.h>
#include <Xm/DialogS.h>
#include <Xm/XmI.h>
#include <stdio.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static XtGeometryResult geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply);
static XmGeoMatrix geoMatrixCreate(Widget _w, Widget _from, XtWidgetGeometry *_pref);
static Boolean noGeoRequest(XmGeoMatrix _geoSpec);

static void defaultDirSearchProc(Widget widget, XtPointer search_data);
static void defaultFileSearchProc(Widget widget, XtPointer search_data);
static void defaultQualifySearchDataProc(Widget widget, XtPointer input_data, XtPointer output_data);

static void _XmFileSelectionSearch(Widget w);


/*
 * Resources for the FileSelection Box class
 */
#define Offset(field) XtOffsetOf(XmFileSelectionBoxRec, file_selection_box.field)
#define SBOffset(field) XtOffsetOf(XmFileSelectionBoxRec, selection_box.field)
static XtResource resources[] = {
    {
	XmNdirectory, XmCDirectory, XmRXmString,
	sizeof(XmString), Offset(directory),
	XmRXmString, (XtPointer)NULL
    },
    {
	XmNpattern, XmCPattern, XmRXmString,
	sizeof(XmString), Offset(pattern),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNdirListLabelString, XmCDirListLabelString, XmRXmString,
	sizeof(XmString), Offset(dir_list_label_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNdirListItems, XmCDirListItems, XmRXmStringTable,
	sizeof(XmStringTable), Offset(dir_list_items),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNdirListItemCount, XmCDirListItemCount, XmRInt,
	sizeof(int), Offset(dir_list_item_count),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNfilterLabelString, XmCFilterLabelString, XmRXmString,
	sizeof(XmString), Offset(filter_label_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNdirMask, XmCDirMask, XmRXmString,
	sizeof(XmString), Offset(dir_mask),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNnoMatchString, XmCNoMatchString, XmRXmString,
	sizeof(XmString), Offset(no_match_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNqualifySearchDataProc, XmCQualifySearchDataProc, XmRProc,
	sizeof(XmQualifyProc), Offset(qualify_search_data_proc),
	XmRImmediate, (XtPointer)defaultQualifySearchDataProc
    },
    {
	XmNdirSearchProc, XmCDirSearchProc, XmRProc,
	sizeof(XmSearchProc), Offset(dir_search_proc),
	XmRImmediate, (XtPointer)defaultDirSearchProc
    },
    {
	XmNfileSearchProc, XmCFileSearchProc, XmRProc,
	sizeof(XmSearchProc), Offset(file_search_proc),
	XmRImmediate, (XtPointer)defaultFileSearchProc
    },
    {
	XmNfileTypeMask, XmCFileTypeMask, XmRFileTypeMask,
	sizeof(unsigned char), Offset(file_type_mask),
	XmRImmediate, (XtPointer)XmFILE_REGULAR
    },
    {
	XmNlistUpdated, XmCListUpdated, XmRBoolean,
	sizeof(Boolean), Offset(list_updated),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNdirectoryValid, XmCDirectoryValid, XmRBoolean,
	sizeof(Boolean), Offset(directory_valid),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNdirSpec, XmCDirSpec, XmRXmString,
	sizeof(XmString), SBOffset(text_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNautoUnmanage, XmCAutoUnmanage, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmFileSelectionBoxRec, bulletin_board.auto_unmanage),
	XmRImmediate, (XtPointer)False
    },
    {
	XmNfileListLabelString, XmCFileListLabelString, XmRXmString,
	sizeof(XmString), SBOffset(list_label_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNapplyLabelString, XmCApplyLabelString, XmRXmString,
	sizeof(XmString), SBOffset(apply_label_string),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	XmNdialogType, XmCDialogType, XmRSelectionType,
	sizeof(unsigned char), SBOffset(dialog_type),
	XmRImmediate, (XtPointer)XmDIALOG_FILE_SELECTION
    },
    {
	XmNfileListItems, XmCItems, XmRXmStringTable,
	sizeof(XmStringTable), SBOffset(list_items),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNfileListItemCount, XmCItemCount, XmRInt,
	sizeof(int), SBOffset(list_item_count),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNdirectory,
	sizeof(XmString), Offset(directory),
	NULL /* FIXME */, NULL
    },
    {
	XmNdirListLabelString,
	sizeof(XmString), Offset(directory),
	NULL /* FIXME */, NULL
    },
    {
	XmNdirListItems,
	sizeof(XmStringTable), Offset(dir_list_items),
	NULL /* FIXME */, NULL
    },
    {
	XmNdirListItemCount,
	sizeof(int), Offset(dir_list_item_count),
	NULL /* FIXME */, NULL
    },
    {
	XmNfilterLabelString,
	sizeof(XmString), Offset(filter_label_string),
	NULL /* FIXME */, NULL
    },
    {
	XmNdirMask,
	sizeof(XmString), Offset(dir_mask),
	NULL /* FIXME */, NULL
    },
    {
	XmNdirSpec,
	sizeof(XmString), SBOffset(text_string),
	NULL /* FIXME */, NULL
    },
    {
	XmNfileListLabelString,
	sizeof(XmString), SBOffset(list_label_string),
	NULL /* FIXME */, NULL
    },
    {
	XmNfileListItems,
	sizeof(XmStringTable), SBOffset(list_items),
	NULL /* FIXME */, NULL
    },
    {
	XmNfileListItemCount,
	sizeof(XmStringTable), SBOffset(list_item_count),
	NULL /* FIXME */, NULL
    },
    {
	XmNnoMatchString,
	sizeof(XmString), Offset(no_match_string),
	NULL /* FIXME */, NULL
    },
    {
	XmNpattern,
	sizeof(XmString), Offset(pattern),
	NULL /* FIXME */, NULL
    }
};

static XmBaseClassExtRec _XmFileSBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

static XmManagerClassExtRec _XmFileSBMClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmManagerClassExtVersion,
    /* record_size               */ sizeof(XmManagerClassExtRec),
    /* traversal_children        */ NULL /* FIXME */
};

XmFileSelectionBoxClassRec xmFileSelectionBoxClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmSelectionBoxClassRec,
        /* class_name            */ "XmFileSelectionBox",
	/* widget_size           */ sizeof(XmFileSelectionBoxRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ XtInheritTranslations,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmFileSBCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */ geometry_manager, 
        /* change_managed   */ XtInheritChangeManaged, 
        /* insert_child     */ XtInheritInsertChild,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ NULL,
    },
    /* Constraint class part */
    {
	/* subresources      */ NULL,  
        /* subresource_count */ 0,     
        /* constraint_size   */ 0,     
        /* initialize        */ NULL,  
        /* destroy           */ NULL,  
        /* set_values        */ NULL,  
        /* extension         */ NULL,  
    },
    /* XmManager class part */
    {
       /* translations                 */ XmInheritTranslations,
       /* syn_resources                */ syn_resources,
       /* num_syn_resources            */ XtNumber(syn_resources),
       /* syn_constraint_resources     */ NULL,
       /* num_syn_constraint_resources */ 0,
       /* parent_process               */ XmInheritParentProcess,
       /* extension                    */ (XtPointer)&_XmFileSBMClassExtRec
    },
    /* XmBulletinBoard class part */
    {
	/* always_install_accelerators  */ False,
	/* geo_matrix_create            */ geoMatrixCreate,
	/* focus_moved_proc             */ XmInheritFocusMovedProc,
	/* extension                    */ NULL,
    },
    /* XmSelectionBox part */
    {
	/* extension */ NULL,
    },
    /* XmFileSelectionBox part */
    {
	/* extension */ NULL,
    }
};

WidgetClass xmFileSelectionBoxWidgetClass = (WidgetClass)&xmFileSelectionBoxClassRec;

#define DEFAULT_NUM_VIS_ITEMS	XmFSB_MAX_WIDGETS_VERT   /* FIXME -- can someone confirm this? */
#define DEFAULT_LIST_WIDTH	100

static void 
class_initialize()
{
    _XmFileSBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmFILE_SELECTION_BOX_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Arg argl[7];
    int argc;
    XmString files;

    SB_DialogType(new) = XmDIALOG_FILE_SELECTION;
    XtManageChild(SB_ApplyButton(new));
    XtManageChild(SB_HelpButton(new));

    /*
     * dir list label
     */
    FS_DirListLabelString(new) =
		_XmOSGetLocalizedString(NULL, /* FIXME */
					new,
					XmNdirListLabelString,
					(String)"Directories");
    FS_DirListLabel(new) = _XmBB_CreateLabelG(new,
					      FS_DirListLabelString(new),
					      "dirListLabel");
    argc = 0;
    XtSetArg(argl[argc], XmNalignment, XmALIGNMENT_BEGINNING); argc++;
    XtSetValues(FS_DirListLabel(new), argl, argc);
    XtManageChild(FS_DirListLabel(new));

    /*
     * dir list
     */
    argc = 0;
    FS_DirListItemCount(new) = DEFAULT_NUM_VIS_ITEMS;
    XtSetArg(argl[argc], XmNvisibleItemCount, FS_DirListItemCount(new)); argc++;
    XtSetArg(argl[argc], XmNselectionPolicy, XmSINGLE_SELECT); argc++;
    XtSetArg(argl[argc], XmNscrollBarDisplayPolicy, XmAS_NEEDED); argc++;
    XtSetArg(argl[argc], XmNscrollingPolicy, XmAUTOMATIC); argc++;
    XtSetArg(argl[argc], XmNlistSizePolicy, XmCONSTANT); argc++;
    XtSetValues(SB_List(new), argl, argc);
    FS_DirList(new) = XmCreateScrolledList(new, "dirList", argl, argc);
    XtManageChild(FS_DirList(new));
    XtManageChild(XtParent(FS_DirList(new)));        /* FIX ME */
    /* The above should be handled in XmScrolledWindow's manage_child */

    /*
     * file list label
     */
    XmStringFree(FS_FileListLabelString(new));
    files = _XmOSGetLocalizedString(NULL, /* FIXME */
				    new,
				    XmNfileListLabelString,
				    "Files");
    FS_FileListLabelString(new) = files;
    argc = 0;
    XtSetArg(argl[argc], XmNlabelString, FS_FileListLabelString(new)); argc++;
    XtSetValues(SB_ListLabel(new), argl, argc);

    /*
     * filter label
     */
    FS_FilterLabelString(new) =
		_XmOSGetLocalizedString(NULL, /* FIXME */
					new,
					XmNfilterLabelString,
					"Filter");
    FS_FilterLabel(new) = _XmBB_CreateLabelG(new,
					     FS_FilterLabelString(new),
					     "filterListLabel");
    argc = 0;
    XtSetArg(argl[argc], XmNalignment, XmALIGNMENT_BEGINNING); argc++;
    XtSetValues(FS_FilterLabel(new), argl, argc);
    XtManageChild(FS_FilterLabel(new));

    /*
     * filter text
     */
    argc = 0;
    FS_FilterText(new) = XmCreateTextField(new, "filterText", argl, argc);
    XtManageChild(FS_FilterText(new));

    _XmFileSelectionSearch(new);
}

static void
destroy(Widget w)
{
	XtDestroyWidget(FS_DirListLabel(w));
	XmStringFree(FS_DirListLabelString(w));
	XtDestroyWidget(FS_DirList(w));
	XtDestroyWidget(FS_FilterLabel(w));
	XmStringFree(FS_FilterLabelString(w));
	XtDestroyWidget(FS_FilterText(w));
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Arg                         al[10];
    int                         ac;
    Boolean                    refresh = False;
    
    XdbDebug(__FILE__, new, "XmSelectionBox %s SetValues\n", XtName(new));

    /* dir list */
    if (FS_DirListItems(new) != FS_DirListItems(old) ||
	FS_DirListItemCount(new) != FS_DirListItemCount(old)) {
	ac = 0;
	XtSetArg(al[ac], XmNitems, FS_DirListItems(new)); ac++;
	XtSetArg(al[ac], XmNitemCount, FS_DirListItemCount(new)); ac++;
	XtSetValues(FS_DirList(new), al, ac);
	refresh = True;
    }
    
    /* dir list label string */
    if (FS_DirListLabelString(new) != FS_DirListLabelString(old)) {
	ac = 0;
	XtSetArg(al[ac], XmNlistLabelString, FS_DirListLabelString(new)); ac++;
	XtSetValues(FS_DirListLabel(new), al, ac);
	refresh = True;
    }
    
    /* label string */
    if (FS_FilterLabelString(new) != FS_FilterLabelString(old)) {
	ac = 0;
	XtSetArg(al[ac], XmNlabelString, FS_FilterLabelString(new)); ac++;
	XtSetValues(FS_FilterLabel(new), al, ac);
	refresh = True;
    }
    
    if (FS_Directory(new) != FS_Directory(old) ||
	FS_DirMask(new) != FS_DirMask(old) ||
	FS_Pattern(new) != FS_Pattern(old) ||
	FS_FileTypeMask(new) != FS_FileTypeMask(old) ||
	FS_QualifySearchDataProc(new) != FS_QualifySearchDataProc(old) ||
	FS_DirSearchProc(new) != FS_DirSearchProc(old) ||
	FS_FileSearchProc(new) != FS_FileSearchProc(old))
	_XmFileSelectionSearch(new);
    
    return refresh;
}

static void 
expose(Widget w, 
       XEvent *event, 
       Region region)
{
    _XmRedisplayGadgets(w, event, region);
}

static XtGeometryResult 
query_geometry(Widget w, 
	       XtWidgetGeometry *proposed, 
	       XtWidgetGeometry *answer)
{
    XdbDebug(__FILE__, w, "\nXmFileSelectionBox %s QueryGeometry\n", XtName(w));

/* FIX ME */
    if (answer) {
	*answer = *proposed;
	answer->request_mode &= CWWidth | CWHeight;
    }

    return XtGeometryYes;
}

static XtGeometryResult
geometry_manager(Widget w,
		 XtWidgetGeometry *request,
		 XtWidgetGeometry *reply)
{
    XmFileSelectionBoxWidget sb = (XmFileSelectionBoxWidget) XtParent(w);
    XtGeometryResult        r = XtGeometryYes;

    if (reply) {
	*reply = *request;
	reply->request_mode &= CWWidth | CWHeight;
    }

#define Wants(x)        (request->request_mode & x)

    if (w == XtParent(SB_List(sb))) {
	Dimension W = XtWidth(sb) - 2 * BB_MarginWidth(sb);

	if (Wants(CWWidth) && request->width != W) {
	    reply->width = W;
	    r = XtGeometryAlmost;
	}
    }

    XdbDebug(__FILE__, w,
	     "\nXmFileSelBox %s GeometryManager for %s [%d %d => %d %d, %s]\n",
             XtName(sb), XtName(w),
             request->width, request->height, reply->width, reply->height,
             XdbGeometryResult2String(r));

    return r;
}

static XmGeoMatrix
geoMatrixCreate(Widget _w, Widget _from, XtWidgetGeometry *_pref)
{
    XmGeoMatrix geoSpec;
    register XmGeoRowLayout	layoutPtr;
    register XmKidGeometry boxPtr;
    Cardinal numKids;
    Boolean newRow;
    int nrows;

    nrows = 0;

    numKids = MGR_NumChildren(_w);

    if (FS_FilterLabel(_w) && XtIsManaged(FS_FilterLabel(_w)))
	nrows++;

    if (FS_FilterText(_w) && XtIsManaged(FS_FilterText(_w)))
	nrows++;

    if ((FS_DirListLabel(_w) && XtIsManaged(FS_DirListLabel(_w))) ||
	(SB_ListLabel(_w) && XtIsManaged(SB_ListLabel(_w))))
	nrows++;

    if ((FS_DirList(_w) && XtIsManaged(FS_DirList(_w))) ||
	(SB_List(_w) && XtIsManaged(SB_List(_w))))
	nrows++;

    if (SB_SelectionLabel(_w) && XtIsManaged(SB_SelectionLabel(_w)))
	nrows++;

    if (SB_Text(_w) && XtIsManaged(SB_Text(_w)))
	nrows++;

    if (SB_Separator(_w) && XtIsManaged(SB_Separator(_w)))
	nrows++;

    if ((BB_CancelButton(_w) && XtIsManaged(BB_CancelButton(_w))) ||
        (SB_OkButton(_w)     && XtIsManaged(SB_OkButton(_w))) ||
        (SB_ApplyButton(_w)  && XtIsManaged(SB_ApplyButton(_w))) ||
        (SB_HelpButton(_w)   && XtIsManaged(SB_HelpButton(_w))))
	nrows++;

    geoSpec = _XmGeoMatrixAlloc(nrows, numKids, 0);
    geoSpec->composite = (Widget)_w;
    geoSpec->instigator = (Widget)_from;
    if (_pref)
	geoSpec->instig_request = *_pref;
    geoSpec->margin_w = BB_MarginWidth(_w) + MGR_ShadowThickness(_w);
    geoSpec->margin_h = BB_MarginHeight(_w) + MGR_ShadowThickness(_w);
    geoSpec->no_geo_request = noGeoRequest;

    layoutPtr = &(geoSpec->layouts->row);
    boxPtr = geoSpec->boxes;

    if (FS_FilterLabel(_w) && XtIsManaged(FS_FilterLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, FS_FilterLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 0;
	layoutPtr->even_height = 1;
	layoutPtr->stretch_height = 0;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
    }

    if (FS_FilterText(_w) && XtIsManaged(FS_FilterText(_w)) &&
	_XmGeoSetupKid(boxPtr, FS_FilterText(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->space_above = 0; /* BB_MarginHeight(_w); */
	layoutPtr++;
	boxPtr += 2;
    }

    newRow = FALSE;
    if (FS_DirListLabel(_w) && XtIsManaged(FS_DirListLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, FS_DirListLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = TRUE;
	boxPtr++;
    }

    if (SB_ListLabel(_w) && XtIsManaged(SB_ListLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_ListLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = TRUE;
	boxPtr++;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

    newRow = FALSE;
    if (FS_DirList(_w) && XtIsManaged(FS_DirList(_w)) &&
	_XmGeoSetupKid(boxPtr, XtParent(FS_DirList(_w))))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above =
		(FS_DirListLabel(_w) && XtIsManaged(FS_DirListLabel(_w)))
			? BB_MarginHeight(_w)
			: 0;
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = TRUE;
	boxPtr++;
    }

    if (SB_List(_w) && XtIsManaged(SB_List(_w)) &&
	_XmGeoSetupKid(boxPtr, XtParent(SB_List(_w))))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = 0; /* BB_MarginHeight(_w); */
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = TRUE;
	boxPtr++;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

    if (SB_SelectionLabel(_w) && XtIsManaged(SB_SelectionLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_SelectionLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 0;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
    }

    if (SB_Text(_w) && XtIsManaged(SB_Text(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_Text(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->stretch_height = 0;
	layoutPtr->even_height = 1;
	layoutPtr->even_width = 0;
	layoutPtr->space_above = 0; /* BB_MarginHeight(_w); */
	layoutPtr++;
	boxPtr += 2;
    }

    if (SB_Separator(_w) && XtIsManaged(SB_Separator(_w)) &&
	_XmGeoSetupKid( boxPtr, SB_Separator(_w)))
    {
	layoutPtr->fix_up = _XmSeparatorFix;
	layoutPtr->space_above = BB_MarginHeight(_w);
	boxPtr += 2;
	layoutPtr++;
    }

    newRow = False;
    if (SB_OkButton(_w)     && XtIsManaged(SB_OkButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, SB_OkButton(_w))) {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (SB_ApplyButton(_w)  && XtIsManaged(SB_ApplyButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, SB_ApplyButton(_w))) {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (BB_CancelButton(_w) && XtIsManaged(BB_CancelButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, BB_CancelButton(_w))) {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (SB_HelpButton(_w)   && XtIsManaged(SB_HelpButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, SB_HelpButton(_w))) {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

    layoutPtr->space_above = 0; /* BB_MarginHeight(_w); */
    layoutPtr->end = TRUE;
    return(geoSpec);
}

static Boolean
noGeoRequest(XmGeoMatrix _geoSpec)
{
	if(BB_InSetValues(_geoSpec->composite) && 
		(XtClass(_geoSpec->composite) == xmFileSelectionBoxWidgetClass))
			return(TRUE);

	return( FALSE);
}

/******************************* SEARCHING **********************************/

static void 
defaultDirSearchProc(Widget widget,
		     XtPointer data)
{
    String *entries, dir, pat;
    XmFileSelectionBoxCallbackStruct *cbs = (XmFileSelectionBoxCallbackStruct *)data;
    unsigned int numents, numalloc, argc, i, max;
    Arg argl[5];
    XmString *table;
    
    if (!XmStringGetLtoR(cbs->dir, XmFONTLIST_DEFAULT_TAG, &dir)) {
	dir = "";
    }
    if (!XmStringGetLtoR(cbs->pattern, XmFONTLIST_DEFAULT_TAG, &pat)) {
	pat = "*";
    }
    entries = NULL;
    numents = numalloc = 0;
    _XmOSGetDirEntries(dir, pat, XmFILE_DIRECTORY, True, True,
		       &entries, &numents, &numalloc);
    
    max = 64;
    table = (XmString *)XtCalloc(max, sizeof(XmString));
    for (i = 0; i < numents; i++) {
	if (i == max) {
	    max *= 2;
	    table = (XmString *)XtRealloc((char *)table, max * sizeof(XmString));
	}
	table[i] = XmStringCreateLtoR(entries[i], XmFONTLIST_DEFAULT_TAG);
    }
    
    argc = 0;
    XtSetArg(argl[argc], XmNitems, table); argc++;
    XtSetArg(argl[argc], XmNitemCount, numents); argc++;
    XtSetValues(FS_DirList(widget), argl, argc);
    FS_DirListItems(widget) = table;
    FS_DirListItemCount(widget) = numents;
    
    FS_DirectoryValid(widget) = True;
    FS_ListUpdated(widget) = True;
}

static void
defaultFileSearchProc(Widget widget,
		      XtPointer data)
{
    String *entries, dir, pat;
    XmFileSelectionBoxCallbackStruct *cbs = (XmFileSelectionBoxCallbackStruct *)data;
    unsigned int numents, numalloc, argc, i, max;
    Arg argl[5];
    XmString *table;
    
    if (!XmStringGetLtoR(cbs->dir, XmFONTLIST_DEFAULT_TAG, &dir)) {
	dir = "";
    }
    if (!XmStringGetLtoR(cbs->pattern, XmFONTLIST_DEFAULT_TAG, &pat)) {
	pat = "*";
    }
    entries = NULL;
    numents = numalloc = 0;
    _XmOSBuildFileList(dir, pat, FS_FileTypeMask(widget),
		       &entries, &numents, &numalloc);
    
    max = 64;
    table = (XmString *)XtCalloc(max, sizeof(XmString));
    for (i = 0; i < numents; i++) {
	if (i == max) {
	    max *= 2;
	    table = (XmString *)XtRealloc((char *)table, max * sizeof(XmString));
	}
	table[i] = XmStringCreateLtoR(entries[i], XmFONTLIST_DEFAULT_TAG);
    }
    
    argc = 0;
    XtSetArg(argl[argc], XmNitems, table); argc++;
    XtSetArg(argl[argc], XmNitemCount, numents); argc++;
    XtSetValues(SB_List(widget), argl, argc);
    SB_ListItems(widget) = table;
    SB_ListItemCount(widget) = numents;
    
    FS_ListUpdated(widget) = True;
}


/*
 * dir part.  Must return an allocated string, even if of zero length.
 */
static void
getDirPart(Widget w,
	   XmFileSelectionBoxCallbackStruct *in,
	   String *directory) {
    String dir, tmp, tmp2;

    dir = XtMalloc(1);
    *dir = 0;

    /*
     * if dir isn't null, we want it
     */
    if (in->dir != NULL) {
	if (XmStringGetLtoR(in->dir, XmFONTLIST_DEFAULT_TAG, &tmp)) {
	    dir=XtRealloc(dir, strlen(tmp) + 1);
	    memcpy(dir, tmp, strlen(tmp));
	    dir[strlen(tmp)] = 0;
	    XtFree(tmp);
	}
	*directory = dir;
	return;
    }

    /*
     * else if the mask isn't null, get the dir from it
     */
    if (in->mask != NULL && in->mask != (XmString)XmUNSPECIFIED) {
	if (XmStringGetLtoR(in->mask, XmFONTLIST_DEFAULT_TAG, &tmp)) {
	    tmp2 = _XmOSFindPatternPart(tmp);
	    if (tmp2 != tmp) {
		dir = XtRealloc(dir, tmp2 - tmp + 1);
		memcpy(dir, tmp, tmp2 - tmp);
		dir[tmp2-tmp] = 0;
	    }
	    XtFree(tmp);
	}
	*directory = dir;
	return;
    }

    /*
     * else it comes from XmNdirectory
     */
    if (FS_Directory(w) != NULL && FS_Directory(w) != (XmString)XmUNSPECIFIED &&
	XmStringGetLtoR(FS_Directory(w),
			XmFONTLIST_DEFAULT_TAG, &tmp)) {
	dir = XtRealloc(dir, strlen(tmp) + 1);
	memcpy(dir, tmp, strlen(tmp));
	dir[strlen(tmp)] = 0;
	XtFree(tmp);
    }
    *directory = dir;
}

/*
 * pattern part.  Must return an allocated string, even if of zero length.
 */
static void
getPatPart(Widget w,
	   XmFileSelectionBoxCallbackStruct *in,
	   String *pattern) {
    String pat, tmp, tmp2;

    pat = XtMalloc(1);
    *pat = 0;

    /*
     * if we have an input pattern, use it
     */
    if (in->pattern != NULL && in->pattern != (XmString)XmUNSPECIFIED) {
	if (XmStringGetLtoR(in->pattern, XmFONTLIST_DEFAULT_TAG, &tmp)) {
	    pat = XtRealloc(pat, strlen(tmp) + 1);
	    memcpy(pat, tmp, strlen(tmp));
	    pat[strlen(tmp)] = 0;
	    XtFree(tmp);
	}
	*pattern = pat;
	return;
    }

    /*
     * else if we have a mask, get the pattern from it
     */
    if (in->mask != NULL && in->mask != (XmString)XmUNSPECIFIED) {
	if (XmStringGetLtoR(in->mask, XmFONTLIST_DEFAULT_TAG, &tmp)) {
	    tmp2 = _XmOSFindPatternPart(tmp);
	    if (tmp2 != tmp) {
		pat = XtRealloc(pat, strlen(tmp2) + 1);
		memcpy(pat, tmp2, strlen(tmp2));
		pat[strlen(tmp2)] = 0;
	    }
	    XtFree(tmp);
	}
	*pattern = pat;
	return;
    }

    /*
     * else it comes from XmNpattern
     */
    if (FS_Pattern(w) != NULL && FS_Pattern(w) != (XmString)XmUNSPECIFIED &&
	XmStringGetLtoR(FS_Pattern(w),
			XmFONTLIST_DEFAULT_TAG, &tmp)) {
	pat = XtRealloc(pat, strlen(tmp) + 1);
	memcpy(pat, tmp, strlen(tmp));
	pat[strlen(tmp)] = 0;
    }

    *pattern = pat;
}

static void 
defaultQualifySearchDataProc(Widget w,
			     XtPointer input_data,
			     XtPointer output_data)
{
    String dir = NULL, pat = NULL, directory = NULL, pattern = NULL;
    XmFileSelectionBoxCallbackStruct *in =
			(XmFileSelectionBoxCallbackStruct *)input_data;
    XmFileSelectionBoxCallbackStruct *out =
			(XmFileSelectionBoxCallbackStruct *)output_data;

    /*
     * heuristic as by OSF/Motif Programmer's Reference Release 1.2.
     * What a pain in the a**
     */

    /*
     * first, if we have both dir and pattern we're ok.
     */
    if (in->dir != NULL && in->pattern != NULL) {
	out->dir = XmStringCopy(in->dir);
	out->dir_length = XmStringLength(out->dir);

	out->pattern = XmStringCopy(in->pattern);
	out->pattern_length = XmStringLength(out->pattern);
    }
    /*
     * otherwise, get the pieces and qualify them
     */
    else {
	getDirPart(w, in, &dir);
	getPatPart(w, in, &pat);

	_XmOSQualifyFileSpec(dir, pat, &directory, &pattern);

	/*
	 * the subroutines MUST ensure this works, or not return
	 */
	XtFree(dir);
	XtFree(pat);

	out->dir = XmStringCreateLtoR(directory, XmFONTLIST_DEFAULT_TAG);
	out->dir_length = XmStringLength(out->dir);

	out->pattern = XmStringCreateLtoR(pattern, XmFONTLIST_DEFAULT_TAG);
	out->pattern_length = XmStringLength(out->pattern);

        XtFree(directory);
        XtFree(pattern);
    }

    out->mask = XmStringConcat(out->dir, out->pattern);
    out->mask_length = XmStringLength(out->mask);
 
    if (in->value == NULL || in->value == (XmString)XmUNSPECIFIED) {
	if (FS_DirSpec(w) && FS_DirSpec(w) != (XmString)XmUNSPECIFIED)
	    out->value = XmStringCopy(FS_DirSpec(w));
	else
	    out->value = XmStringConcat(out->dir, out->pattern);
    }
    else
	out->value = XmStringCopy(in->value);
    out->length = XmStringLength(out->value);
    out->reason = in->reason;
    out->event = in->event;
}

/*
 * search procedure.  Algorithm per
 * OSF/M*tif Programmer's Reference Release 1.2, 1-446
 */
static void
_XmFileSelectionSearch(Widget w) {
    XmFileSelectionBoxCallbackStruct in, out;
    Arg argl[5];
    int argc;
    
    /*
     * setup the callback structures
     */
    in.reason = 0;
    in.event = NULL;
    in.value = NULL;
    in.length = 0;
    in.mask = FS_DirMask(w);
    if (in.mask && in.mask != (XmString)XmUNSPECIFIED)
	in.mask_length = XmStringLength(FS_DirMask(w));
    in.dir = FS_Directory(w);
    if (in.dir && in.dir != (XmString)XmUNSPECIFIED)
	in.dir_length = XmStringLength(FS_Directory(w));
    in.pattern = FS_Pattern(w);
    if (in.pattern && in.pattern != (XmString)XmUNSPECIFIED)
	in.pattern_length = XmStringLength(FS_Pattern(w));
    
    /*
     * qualification
     */
    (*FS_QualifySearchDataProc(w))(w, &in, &out);
    
    /*
     * dir search
     */
    FS_DirectoryValid(w) = False;
    FS_ListUpdated(w) = False;
    (*FS_DirSearchProc(w))(w, &out);
    
    /*
     * file search
     */
    if (FS_DirectoryValid(w)) {
	char *value;
	
	FS_ListUpdated(w) = False;
	(*FS_FileSearchProc(w))(w, &out);
	if (FS_ListUpdated(w) && SB_ListItemCount(w) == 0) {
	    argc = 0;
	    XtSetArg(argl[argc], XmNitems, FS_NoMatchString(w)); argc++;
	    XtSetValues(SB_List(w), argl, argc);
	    argc = 0;
	    value = XtMalloc(1);
	    *value = 0;
	    XtSetArg(argl[argc], XmNvalue, value); argc++;
	    XtSetValues(SB_Text(w), argl, argc);
	}
	else if (FS_ListUpdated(w)) {
	    FS_DirSpec(w) = out.dir;
	    XmStringGetLtoR(out.dir, XmFONTLIST_DEFAULT_TAG, &value);
	    
	    argc = 0;
	    XtSetArg(argl[argc], XmNvalue, value); argc++;
	    XtSetValues(SB_Text(w), argl, argc);
	}
	
	FS_DirMask(w) = out.mask;
	
	XmStringGetLtoR(FS_DirMask(w), XmFONTLIST_DEFAULT_TAG, &value);
	argc = 0;
	XtSetArg(argl[argc], XmNvalue, value); argc++;
	XtSetValues(FS_FilterText(w), argl, argc);
	
	FS_Directory(w) = out.dir;
	FS_Pattern(w) = out.pattern;
    }
}

/************************** END WIDGET METHODS ****************************/

/************************** EXTERNAL FUNCTIONS ****************************/
Widget
XmCreateFileSelectionBox(Widget parent,
			 char *name,
			 Arg *argList,
			 Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmFileSelectionBoxWidgetClass,
			  parent,
			  argList,
			  argcount);
}

Widget 
XmCreateFileSelectionDialog(Widget parent, 
			    char *name,
			    Arg *argList,
			    Cardinal argcount)
{
    Widget      d, ret;
    char        *s;
    Arg         a;

    s = _XmMakeDialogName(name);

    d = XtCreateWidget(s, xmDialogShellWidgetClass, parent, argList, argcount);
    XtFree(s);
    XtSetArg(a, XmNallowShellResize, True);
    XtSetValues(d, &a, 1);

    ret = XtCreateWidget(name, xmFileSelectionBoxWidgetClass, d, argList, argcount);

    XtSetArg(a, XmNdialogType, XmDIALOG_FILE_SELECTION);

    XtSetValues(ret, &a, 1);

    return ret;
}

Widget
XmFileSelectionBoxGetChild(Widget w,
			   unsigned char child)
{
    switch(child) {
    case XmDIALOG_APPLY_BUTTON:
	return SB_ApplyButton(w);
    case XmDIALOG_CANCEL_BUTTON:
	return SB_CancelButton(w);
    case XmDIALOG_OK_BUTTON:
	return SB_OkButton(w);
    case XmDIALOG_FILTER_TEXT:
	return SB_CancelButton(w);
    case XmDIALOG_HELP_BUTTON:
	return SB_HelpButton(w);
    case XmDIALOG_LIST:
	return SB_List(w);
    case XmDIALOG_SEPARATOR:
	return SB_Separator(w);
    case XmDIALOG_TEXT:
	return SB_Text(w);
    case XmDIALOG_LIST_LABEL:
	return SB_ListLabel(w);
    case XmDIALOG_SELECTION_LABEL:
	return SB_SelectionLabel(w);
    case XmDIALOG_FILTER_LABEL:
	return FS_FilterLabel(w);
    case XmDIALOG_DIR_LIST:
	return FS_DirList(w);
    case XmDIALOG_DIR_LIST_LABEL:
	return FS_DirListLabel(w);

/* Still have to treat these */
    case XmDIALOG_MESSAGE_LABEL:
    case XmDIALOG_DEFAULT_BUTTON:
    case XmDIALOG_SYMBOL_LABEL:
              return BB_DefaultButton(w);
    }
    return NULL;
}

void
XmFileSelectionDoSearch(Widget w,
			XmString dirmask)
{
}
