.lf 1 sql/altertbl.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/devel/pglite/cvs/src/doc/ref/sql/altertbl.cmdsrc,v 1.1 1996/02/24 01:16:49 jolly Exp $
.TH ALTER TABLE COMMANDS 11/5/95
.XA 2 "Alter Table"
.SH NAME
alter table \(em add attributes to a class
.SH SYNOPSIS
.(l M
\fBalter table\fR classname [*]
	\fBadd column\fR attname type
	
.)l
.SH DESCRIPTION
The
.BR "alter table"
command
causes a new attribute to be added to an existing class,
.IR classname .
The new attributes and their types are specified
in the same style and with the the same restrictions as in
.IR create table (commands).
.PP
In order to add an attribute to each class in an entire inheritance
hierarchy, use the
.IR classname
of the superclass and append a \*(lq*\*(rq.  (By default, the
attribute will not be added to any of the subclasses.)  This should
.BR always
be done when adding an attribute to a superclass.  If it is not,
queries on the inheritance hierarchy such as
.(C
select * from super* s
.)C
will not work because the subclasses will be missing an attribute
found in the superclass.
.PP
For efficiency reasons, default values for added attributes are not
placed in existing instances of a class.  That is, existing instances
will have NULL values in the new attributes.  If non-NULL values are
desired, a subsequent
.IR update (commands)
query should be run.
.PP
You must own the class in order to change its schema.
.SH EXAMPLE
.(C
--
-- add the date of hire to the emp class
-- 
alter table emp add column hiredate abstime
.)C
.(C
--
-- add a health-care number to all persons
-- (including employees, students, ...)
--
alter table person * add column health_care_id int4
.)C
.SH "SEE ALSO"
create table (commands),
update (commands).
