/* s_dc_swp.cc
 *$Header: /al/acs/src/RCS/s_dc_swp.cc,v 9.22 95/10/22 02:54:04 al Exp $
 * dc analysis sweep
 */
#include "error.h"
#include "io.h"
#include "e_card.h"
#include "u_opt.h"
#include "u_status.h"
#include "s_dc.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	DCOP::sweep(void);
//	void	DCOP::first(int);
//	int	DCOP::next(int);
/*--------------------------------------------------------------------------*/
void DCOP::sweep(void)
{
  int converged;
  int itl = OPT::itl[OPT::DCBIAS];
  
  head(start[0], stop[0], linswp[0], " ");
  bypass_ok = FALSE;
  inc_mode = BAD;
  if (cont){
    restore();
  }
  
  first(0);
  do {
    IO::suppresserrors = trace < tVERBOSE;
    converged = solve(itl,trace);
    if (!converged)
      error(bWARNING, "did not converge\n");
    keep();
    out(*sweepval[0]);
    itl = OPT::itl[OPT::DCXFER];
  } while (next(0));
}
/*--------------------------------------------------------------------------*/
void DCOP::first(int ii)
{
  *sweepval[ii] = start[ii];
  if (exists(zap[ii]))
    zap[ii]->expand();
  
  if (reverse){
    reverse = FALSE;
    while (next(ii))
      /* nothing */;
    reverse = TRUE;
    next(ii);
  }
  STATUS::control[cSTEPCAUSE] = scUSER;
}
/*--------------------------------------------------------------------------*/
int DCOP::next(int ii)
{
  int ok = FALSE;
  if (linswp[ii]){
    double fudge = step[ii] / 10.;
    if (step[ii] == 0.){
      ok = FALSE;
    }else{
      if (!reverse){
	*(sweepval[ii]) += step[ii];
	ok=inorder(start[ii]-fudge,*(sweepval[ii]),stop[ii]+fudge);
	if (!ok  &&  loop)
	  reverse = TRUE;
      }
      if (reverse){
	*(sweepval[ii]) -= step[ii];
	ok=inorder(start[ii]-fudge,*(sweepval[ii]),stop[ii]+fudge);
      }
    }
  }else{
    double fudge = pow(step[ii], .1);
    if (step[ii] == 1.){
      ok = FALSE;
    }else{
      if (!reverse){
	*(sweepval[ii]) *= step[ii];
	ok=inorder(start[ii]/fudge,*(sweepval[ii]),stop[ii]*fudge);
	if (!ok  &&  loop)
	  reverse = TRUE;       
      }
      if (reverse){
	*(sweepval[ii]) /= step[ii];
	ok=inorder(start[ii]/fudge,*(sweepval[ii]),stop[ii]*fudge);
      }
    }
  }
  if (exists(zap[ii]))
    zap[ii]->expand();
  STATUS::control[cSTEPCAUSE] = scUSER;
  return ok;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
