
/*-
# X-BASED TRIANGLES
#
#  xtriangles.c
#
###
#
#  Copyright (c) 1994 - 96	David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 4: 94/06/07 Xt
  Version 3: 93/04/01 Motif
  Version 2: 92/01/06 XView
  Version 1: 91/09/05 SunView
*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#define getlogin cuserid
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Triangles.h"
#include "triangles.xbm"

#ifndef SCOREFILE
#define SCOREFILE "/usr/games/lib/triangles.scores"
#endif

/* The following are in TrianglesP.h also */
#define MINTRIANGLES 1

#define MAXTRIANGLES 16
#define MAXRECORD 32767
#define MAXPROGNAME 80
#define MAXNAME 256

static void Initialize(Widget w);
static void CallbackTriangles(Widget w, caddr_t clientData,
			      trianglesCallbackStruct * callData);

static void PrintRecord(int size, char *record);
static int  HandleSolved(int counter, int size);
static void PrintState(Widget w, char *prog, int size, int moves,
		       char *record, char *message);
static void ReadRecords(void);
static void WriteRecords(void);

static Arg  arg[2];
static int  trianglesRecord[MAXTRIANGLES - MINTRIANGLES + 1], movesDsp = 0;
static char progDsp[64] = "xtriangles";
static char recordDsp[16] = "INF";
static char messageDsp[128] = "Welcome";
static char titleDsp[256] = "";

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xtriangles\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
		 "\t[-tile {color}] [-{border|bd} {color}] [-size {int}]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*triangles.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*triangles.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-tile", "*triangles.tileColor", XrmoptionSepArg, NULL},
	{"-border", "*triangles.tileBorder", XrmoptionSepArg, NULL},
	{"-bd", "*triangles.tileBorder", XrmoptionSepArg, NULL},
	{"-size", "*triangles.size", XrmoptionSepArg, NULL}
};

int
main(int argc, char **argv)
{
	Widget      toplevel, triangles;

	toplevel = XtInitialize(argv[0], "Triangles",
				options, XtNumber(options), &argc, argv);
	if (argc != 1)
		Usage();

	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
		(char *) triangles_bits, triangles_width, triangles_height));
	XtSetArg(arg[1], XtNinput, True);
	XtSetValues(toplevel, arg, 2);
	triangles = XtCreateManagedWidget("triangles", trianglesWidgetClass, toplevel,
					  NULL, 0);
	XtAddCallback(triangles, XtNselectCallback,
		      (XtCallbackProc) CallbackTriangles, (XtPointer) NULL);
	Initialize(triangles);
	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(triangles), AnyButton, AnyModifier, XtWindow(triangles),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(triangles),
		    XCreateFontCursor(XtDisplay(triangles), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void
Initialize(Widget w)
{
	int         size;

	XtVaSetValues(w,
		      XtNstart, FALSE,
		      NULL);
	XtVaGetValues(w,
		      XtNsize, &size,
		      NULL);
	ReadRecords();
	PrintRecord(size, recordDsp);
	PrintState(XtParent(w), progDsp, size, movesDsp,
		   recordDsp, messageDsp);
}

static void
CallbackTriangles(Widget w, caddr_t clientData,
		  trianglesCallbackStruct * callData)
{
	int         size;

	XtVaGetValues(w,
		      XtNsize, &size,
		      NULL);
	(void) strcpy(messageDsp, "");
	switch (callData->reason) {
		case TRIANGLES_RESTORE:
		case TRIANGLES_RESET:
			movesDsp = 0;
			break;
		case TRIANGLES_BLOCKED:
			(void) strcpy(messageDsp, "Blocked");
			break;
		case TRIANGLES_SPACE:
			/*(void) strcpy(messageDsp, "Spaces can't move"); *//* Too annoying */
			break;
		case TRIANGLES_IGNORE:
			(void) strcpy(messageDsp, "Randomize to start");
			break;
		case TRIANGLES_MOVED:
			movesDsp++;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_SOLVED:
			if (HandleSolved(movesDsp, size))
				(void) sprintf(messageDsp, "Congratulations %s!!", getlogin());
			else
				(void) strcpy(messageDsp, "Solved!");
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_RANDOMIZE:
			movesDsp = 0;
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_DEC:
			movesDsp = 0;
			size--;
			PrintRecord(size, recordDsp);
			XtSetArg(arg[0], XtNsize, size);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_INC:
			movesDsp = 0;
			size++;
			PrintRecord(size, recordDsp);
			XtSetArg(arg[0], XtNsize, size);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_COMPUTED:
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case TRIANGLES_UNDO:
			movesDsp--;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
	}
	PrintState(XtParent(w), progDsp, size, movesDsp,
		   recordDsp, messageDsp);
}

static void
PrintRecord(int size, char *record)
{
	int         i = size - MINTRIANGLES;

	if (size > MAXTRIANGLES)
		(void) strcpy(record, "NOT RECORDED");
	else if (trianglesRecord[i] >= MAXRECORD)
		(void) strcpy(record, "NEVER");
	else
		(void) sprintf(record, "%d", trianglesRecord[i]);
}

static int
HandleSolved(int counter, int size)
{
	int         i = size - MINTRIANGLES;

	if (size <= MAXTRIANGLES && counter < trianglesRecord[i]) {
		trianglesRecord[i] = counter;
		WriteRecords();
		(void) sprintf(recordDsp, "%d", counter);
		return TRUE;
	}
	return FALSE;
}

static void
PrintState(Widget w, char *prog, int size, int moves, char *record, char *message)
{
	(void) sprintf(titleDsp, "%s: %d@ (%d/%s) - %s",
		       prog, size, moves, record, message);
	XtSetArg(arg[0], XtNtitle, titleDsp);
	XtSetValues(w, arg, 1);
}

static void
ReadRecords(void)
{
	FILE       *fp;
	int         i, n;

	for (i = 0; i < MAXTRIANGLES - MINTRIANGLES + 1; i++)
		trianglesRecord[i] = MAXRECORD;
	if ((fp = fopen(SCOREFILE, "r")) == NULL)
		(void) sprintf(messageDsp, "Can not open %s, taking defaults.", SCOREFILE);
	else {
		for (i = 0; i < MAXTRIANGLES - MINTRIANGLES + 1; i++) {
			(void) fscanf(fp, "%d", &n);
			trianglesRecord[i] = n;
		}
		(void) fclose(fp);
	}
}

static void
WriteRecords(void)
{
	FILE       *fp;
	int         i;

	if ((fp = fopen(SCOREFILE, "w")) == NULL)
		(void) sprintf(messageDsp, "Can not write to %s.", SCOREFILE);
	else {
		for (i = 0; i < MAXTRIANGLES - MINTRIANGLES + 1; i++)
			(void) fprintf(fp, "%d ", trianglesRecord[i]);
		(void) fprintf(fp, "\n");
		(void) fclose(fp);
	}
}
