# -*- sh -*-
# Makefile for VMS version of SLRN
# The default C compiler is DEC C
#

.IFDEF __MMK__
.ELSE
EXE = .EXE
OBJ = .OBJ
OLB = .OLB
OPT = .OPT
.ENDIF


.IFDEF DEBUG
DBG = /debug /nooptim
LFLAGS = /debug
TARGET = slrn_debug$(EXE)
.ELSE
DBG =
LFLAGS =
TARGET = slrn$(EXE)
.ENDIF

# Default to NETLIB if nothing specified

.IFDEF MULTINET
TCPVER = MULTINET
COPTS = /PREFIX=(ALL,EXCEPT=(SOCKET,CONNECT,BIND,LISTEN,SOCKET_READ,-
            SOCKET_WRITE,SOCKET_CLOSE,SELECT,ACCEPT,BCMP,BCOPY,BZERO,-
            GETHOSTBYNAME,GETHOSTBYADDR,GETPEERNAME,GETDTABLESIZE,HTONS,-
            HTONL,NTOHS,NTOHL,SEND,SENDTO,RECV,RECVFROM))
.ELSE
.IFDEF UCX
TCPVER = UCX
COPTS = /PREFIX=ALL
.ELSE
COPTS = /PREFIX=ALL
TCPVER = NETLIB
.ENDIF
.ENDIF


.IFDEF VAXC
EXTRA_LIBS = ,[]VAXC.OPT/OPTION

.FIRST
	DEFINE sys sys$library
	copy slrnconf.h config.h

.LAST
	DEASSIGN sys

COPTS = 
.ELSE
EXTRA_LIBS = 
.FIRST
        copy slrnconf.h config.h

.ENDIF

SLANGDIR = [-.-.SLANG.SRC]
LIBDIR   = LIB$:[NEWS]

LIBS = $(SLANGDIR)SLANG.OLB/LIBR, []$(TCPVER).OPT/OPTION $(EXTRA_LIBS)

CFLAGS = $(DBG) $(COPTS) /INCLUDE=($(SLANGDIR)) /DEFINE=($(TCPVER),SLRN_LIB_DIR="""$(LIBDIR)""")/nowarning

  
OFILES = slrn$(OBJ), group$(OBJ), misc$(OBJ), server$(OBJ), -
	 art$(OBJ), post$(OBJ), startup$(OBJ), help$(OBJ), hash$(OBJ), -
	 vms$(OBJ), score$(OBJ), vmsmail$(OBJ), mime$(OBJ), uudecode$(OBJ), -
	 menu$(OBJ)

all : $(TARGET)
	continue

$(TARGET) : slangversion $(OFILES)
    LINK/EXEC=$@ $(LFLAGS) $(OFILES), $(LIBS)

slangversion : chkslang$(EXE)
	@ CHKSLANG := $SYS$DISK:[]CHKSLANG
	CHKSLANG slrn 9930 9930
	
chkslang$(EXE) : chkslang$(OBJ)
	$(LINK) /EXEC=$@ chkslang$(OBJ) $(EXTRA_LIBS)

chkslang$(OBJ) : chkslang.c $(SLANGDIR)slang.h
	$(CC) /INCLUDE=($(SLANGDIR)) /OBJECT=$@ chkslang.c


art$(OBJ) : art.c, $(SLANGDIR)slang.h, slrn.h, group.h, nntp.h, art.h, misc.h, post.h, clientlib.h, startup.h, hash.h

clientlib$(OBJ) : clientlib.c, clientlib.h, nntp.h

group$(OBJ) : group.c, $(SLANGDIR)slang.h, clientlib.h, slrn.h, group.h, art.h, misc.h, post.h, nntp.h, hash.h

hash$(OBJ) : hash.c, hash.h

help$(OBJ) : help.c, slrn.h, misc.h, $(SLANGDIR)slang.h

misc$(OBJ) : misc.c, misc.h, $(SLANGDIR)slang.h, group.h, slrn.h

nntp$(OBJ) : nntp.c, nntp.h, clientlib.h, misc.h, slrn.h

post$(OBJ) : post.c, post.h, clientlib.h, misc.h, slrn.h, nntp.h, $(SLANGDIR)slang.h

slrn$(OBJ) : slrn.c, slrn.h, clientlib.h, nntp.h, group.h, misc.h, startup.h, $(SLANGDIR)slang.h

startup$(OBJ) : startup.c, startup.h, slrn.h, group.h, misc.h, art.h, post.h, $(SLANGDIR)slang.h

clean :
    delete *$(OBJ);*, $(TARGET);*, chkslang$(EXE);*
