/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * The code for tray loading was shamelessly stolen from
 * load-unload-1.1 released under GNU terms by
 * Jrgen P. Meier (jor@muecke.rz.fh-muenchen.de)
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <linux/scsi.h>

#include "struct.h"
#include "cd.h"
#include "scsi.h"
#include "sg.h"

/****************************************************************************/

struct sg_request {
  struct sg_header header;
  unsigned char bytes[16];
} sg_request;

struct sg_reply {
  struct sg_header header;
  unsigned char bytes[16];
};

/****************************************************************************
 *
 * Some scsi cdrom drives support tray loading under software control.
 * On non scsi drives, this function just returns ok without actually
 * doing anything.
 */
int load_cd(void) {
  int scsi_fd;
  struct sg_reply reply;
  struct sg_request request;
  int reply_len, exp_size, act_size;

  if (!scsi_name) return 0;

  scsi_fd = open(scsi_name, O_RDWR);
  if (scsi_fd<0) {
    fprintf(stderr, "%s: Failed to open generic scsi device %s: %s\n"
    "   Note: XPlaycd will still work, but you won't be able to load the\n"
    "         tray by pressing a button. Not a big loss anyway...\n",
	    myname, scsi_name, strerror(errno));
    return 0;
  }

#ifdef DEBUG_SCSI
  fprintf(stderr, "load_cd()\n");
#endif

  reply_len = sizeof(struct sg_reply);
  memset(&reply, 0, sizeof(reply));
  memset(&request, 0, sizeof(request));

  request.header.pack_len = sizeof(struct sg_header) + 6;
  request.header.reply_len = reply_len + sizeof(struct sg_header);
  request.header.pack_id = 0;
  request.header.result = 0;

  request.bytes[0] = 0x1B;
  request.bytes[1] = 0;
  request.bytes[2] = 0;
  request.bytes[3] = 0;
  request.bytes[4] = 3; /* 3 means load tray, 2 means eject tray */
  request.bytes[5] = 0;

  exp_size = sizeof(struct sg_header) + 6;
  act_size = write(scsi_fd, &request, exp_size);
  if (act_size < 0) {
    fprintf(stderr, "%s: write to %s failed: %s\n",
	    myname, scsi_name, strerror(errno));
    return 0;
  }

  if (act_size != exp_size) {
    printf("%s: wrote %d bytes to %s, expected %d.\n",
	   myname, act_size, scsi_name, exp_size);
  }

#ifdef DEBUG_SCSI
  fprintf(stderr, "load_cd() sent\n");
#endif

  read(scsi_fd, &reply, sizeof(struct sg_reply));

#ifdef DEBUG_SCSI
  fprintf(stderr, "load_cd() reply read\n");
#endif

  close(scsi_fd);

#ifdef DEBUG_SCSI
  fprintf(stderr, "load_cd() closed\n");
#endif

  return 0;
}


