#include <stdio.h>
#define MSGLEN 1024
#include <string.h>
#include "List.h"
/*-------- Public functions --------------*/
int IsThereWarning();
int IsThereError();
void CleanErrorMessages(int type);
void warning(char *msg);
void fatal(char *msg);
char *GetErrorMsg();
List *GetWarningList();
void CollectWarnings(const char *data, int i);
/*-------- Private functions --------------*/
void AddWarning(char *msg);
/*-------- Private variables --------------*/
static List *Warnings = NULL;
static char ErrorMsg[MSGLEN] = "";

void fatal(char *msg)
{
	sprintf(ErrorMsg, "Error: %s", msg);
#ifdef VERBOSE
	fprintf(stderr, ErrorMsg);
#endif
}

void warning(char *msg)
{
	char WarningMsg[MSGLEN];
	sprintf(WarningMsg, "Warning: %s", msg);
	AddWarning(WarningMsg);
}

void AddWarning(char *msg)
{
	if (!Warnings)
	  	Warnings = NewList();
	
	if(!NewListEntry(Warnings, msg))
	{
		fatal("Not enough memory\n");
		exit(1);
	}		
#ifdef VERBOSE
	fprintf(stderr, msg);
#endif
}

void ClearErrorMessages(int type)
{
	static int Persistent = 0;
	if(!Persistent)	
	{		
		FreeList(Warnings);
		Warnings = NULL;
	}	
	ErrorMsg[0] = '\0';
	Persistent = type;
}

int IsThereError()
{
	return(	ErrorMsg[0] != '\0' );
}

int IsThereWarning()
{
	return(Warnings?1:0);
}

char *GetErrorMsg()
{
	return ErrorMsg;	
}

List *GetWarningList()
{
	return Warnings;	
}


/*
 * Get a list pointer an insert the data in it, one line per list entry
 *  If data does no end in \n, future calls will append data to the
 *  previous entry.
 */
void CollectWarnings(const char *data, int i)
{
	static int FlagNewLine = 1;
	int pos=0;
	static char superstring[200];
	while(i--)
	{
		if(data[pos] == '\n')
		{
			char tmp[200];
			strncpy(tmp, data, pos);
			tmp[pos] = '\n';
			tmp[pos+1] = '\0';
			if (!FlagNewLine)
			{
				strcat(superstring, tmp);
			}
			else
			{	
				superstring[0] = '\0';
				strcpy(superstring, tmp);
			}
			data = data + pos + 1;
			pos = 0;
			FlagNewLine = 1;
			AddWarning(superstring);
 		}
		else
			pos++;
	}
	if (pos)
	{		
		if (!FlagNewLine)
			strcat(superstring, data);
		else
		{	
			superstring[0] = '\0';
			strcpy(superstring, data);
		}
		FlagNewLine = 0;
	}
}
