#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include "directory.h"
#include <sys/stat.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "config.h"
#include "nodelist.h"
#include "nlindex.h"
#ifdef USE_DBZ
#include "nldbz.h"
#endif

#ifdef HAS_NDBM_H
DBM *nldb=NULL;
#endif
int openstatus = 0;
int n;

DIR *dp;
struct dirent *de;

struct _nodelist *nodevector;

struct _pkey pkey[] =
{
  {"Down",	NL_NODE,	NL_DOWN},
  {"Hold",	NL_NODE,	NL_HOLD},
  {"Host",	NL_NET,		0},
  {"Hub",	NL_NODE,	NL_HUB},
  {"Point",	NL_POINT,	0},
  {"Pvt",	NL_NODE,	NL_PVT},
  {"Region",	NL_NET,		NL_REGION},
  {"Zone",	NL_ZONE,	0},
  {NULL,	0,		0}
};

struct _fkey fkey[] =
{
  {"CM", NL_CM},
  {"MO", NL_MO},
  {"LO", NL_LO},
  {"V21", NL_V21},
  {"V22", NL_V22},
  {"V29", NL_V29},
  {"V32", NL_V32},
  {"V32B", NL_V32B | NL_V32},
  {"V33", NL_V33},
  {"V34", NL_V34},
  {"V42", NL_V42 | NL_MNP},
  {"V42B", NL_V42B | NL_V42 | NL_MNP},
  {"MNP", NL_MNP},
  {"H96", NL_H96},
  {"HST", NL_HST | NL_MNP},
  {"H14", NL_H14 | NL_HST | NL_MNP},
  {"H16", NL_H16 | NL_H14 | NL_HST | NL_MNP | NL_V42B},
  {"MAX", NL_MAX},
  {"PEP", NL_PEP},
  {"CSP", NL_CSP},
  {"ZYX", NL_ZYX | NL_V32B | NL_V32 | NL_V42B | NL_V42 | NL_MNP},
  {"MN", NL_MN},
  {"XA", NL_XA},
  {"XB", NL_XB},
  {"XC", NL_XC},
  {"XP", NL_XP},
  {"XR", NL_XR},
  {"XW", NL_XW},
  {"XX", NL_XX},
  {NULL, 0}
};


#ifdef USE_DBZ
static int checkmatch(struct _ixentry *addr, struct _loc *loc)
{
  /* TODO: add full support for points */
  if ((addr->net == loc->net) && (addr->node == loc->node) &&
      (addr->zone == getzone(&nodevector[loc->nlnum & 32767].zonelist, loc->off)))
    return 1;

  return 0;
}
#endif

int initnl(void)
{
	int i,rc;
	fa_list *tmp;
	time_t lastmtime;
	struct stat stbuf;
	char *indexnm,*nlnm=NULL,*p;

	if (openstatus > 1) return openstatus;
	if (openstatus == 1) return 0;

	n=0;
	for (tmp=nllist;tmp;tmp=tmp->next) n++;
	debug(DBG_NODELIST,"Initialize %d nodelists",n);

	nodevector=(struct _nodelist *)xmalloc(n * sizeof(struct _nodelist));

	lastmtime=configtime;
	i=0;
	for (tmp=nllist;tmp;tmp=tmp->next)
	{
		if (tmp->addr->domain)
			nodevector[i].domain=tmp->addr->domain;
		else if (whoami->addr->domain)
			nodevector[i].domain=whoami->addr->domain;
		else
			nodevector[i].domain="fidonet";

		nlnm=xstrcpy(tmp->addr->name);
		if ((rc=stat(tmp->addr->name,&stbuf)) != 0)
		{
			int next,mext=0;

			if (nlnm) free(nlnm);
			if ((nlnm=strrchr(tmp->addr->name,'/')))
				nlnm++;
			else nlnm=tmp->addr->name;
			if (dp == NULL) dp=opendir(nlbase);
			if (dp != NULL)
			{
				rewinddir(dp);
				while ((de=readdir(dp)))
				if (strncmp(de->d_name,nlnm,strlen(nlnm)) == 0)
				{
					p=(de->d_name)+strlen(nlnm);
					if ((*p == '.') && (strlen(p) == 4) &&
					    (strspn(p+1,"0123456789") == 3))
					{
						next=atoi(p+1);
						if (next > mext) mext=next;
					}
				}
			}
			else logerr("$cannot open \"%s\" directory",S(nlbase));
			nlnm=xstrcpy(tmp->addr->name);
			nlnm=xstrcat(nlnm,".999");
			sprintf(nlnm+strlen(nlnm)-3,"%03d",mext);
			debug(DBG_NODELIST,"try \"%s\" nodelist",S(nlnm));
			rc=stat(nlnm,&stbuf);
		}
		if (rc == 0)
		{
			if (stbuf.st_mtime > lastmtime) 
				lastmtime=stbuf.st_mtime;
			nodevector[i].fp=fopen(nlnm,"r");
			if (nodevector[i].fp == NULL)
				logerr("$cannot open nodelist \"%s\"",S(nlnm));
			else debug(DBG_NODELIST,"opened nodelist \"%s\"",S(nlnm));
		}
		else
		{
			logerr("$cannot stat nodelist \"%s\"",
				S(tmp->addr->name));
			nodevector[i].fp=NULL;
		}
		i++;
		if (nlnm) free(nlnm);
	}

	if (dp != NULL) closedir(dp);
	dp=NULL;

	for (i=0;i<n;i++)
	{
		debug(DBG_NODELIST,"nodelist: %3d: %-08s %08lx",
			i,nodevector[i].domain,nodevector[i].fp);
	}

	indexnm=xstrcpy(nlbase);
	indexnm=xstrcat(indexnm,INDEX);
#ifdef NEWDB
	indexnm=xstrcat(indexnm,DBM_SUFFIX);
#else
	indexnm=xstrcat(indexnm,".dir");
#endif
	if ((stat(indexnm,&stbuf) != 0) || (stbuf.st_mtime < lastmtime)) rc=1;
	else rc=0;

#ifdef NEWDB
	indexnm[strlen(indexnm)-strlen(DBM_SUFFIX)]='\0';
#else
	indexnm[strlen(indexnm)-4]='\0';
#endif
	debug(DBG_NODELIST,"Trying open existing \"%s\"",S(indexnm));
#ifdef USE_DBZ
	dbzcheck(checkmatch);
#endif
#ifdef HAS_NDBM_H
	if (nldb == NULL)
	if ((nldb=dbm_open(indexnm,O_RDONLY,0600)) == NULL)
		rc=2;
#else
	if (dbminit(indexnm) != 0) rc=2;
#endif

	free(indexnm);

	if (rc > 1)
	{
		openstatus=2;
		logerr("$cannot open nodelist index (%d)",rc);
	}
	else
	{
#ifdef USE_DBZ
	  /* initialize zone listing */
	  for (i = 0; i < n; i++)
	  {
	    nodevector[i].zonelist.entryvector = NULL;
	    nodevector[i].zonelist.entries = 0;
	    nodevector[i].zonelist.size = 0;
	  }

	  /* read the zone-listing */
	  getzonelist(nodevector);
#endif

	  openstatus=1;
	}

	return rc;
}
