/*
 * psfaddtable.c
 *
 * Add a Unicode character table to a PSF font
 *
 * Copyright (C) 1994 H. Peter Anvin
 *
 * This program may be freely copied under the terms of the GNU
 * General Public License (GPL), version 2, or at your option
 * any later version.
 *
 * Added input ranges, aeb.
 * 1997/08, ydi: moved reusable parts into psf.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <sysexits.h>
#include <string.h>
#include <ctype.h>

#include <lct/font.h>
#include <lct/local.h>

int verbose;
char* progname;

void usage()
{
  version();
  
  fprintf(stderr, "Usage: \n"
	          "        %s psffont chartable [outfile]\n", progname);
}

int main(int argc, char *argv[])
{
  FILE *in, *ctbl, *out, *mapf;
  char pathname[1024];
  char *inname, *tblname;
  char buffer[65536];
  struct unimapdesc map;
/*  struct unicode_list *unilist[512];*/
  struct psf_header psfhdr;
  size_t fontlen;

  progname = strip_path(argv[0]);
  
  if ( argc < 3 || argc > 4 )
    badusage("wrong number of args");

  /* open input font */
  if ( !strcmp(argv[1],"-") )
    {
      in = stdin;
      inname = "stdin";
    }
  else
    {
      in = fopen(inname = argv[1], "r");
      if ( !in )
	{
	  perror(inname);
	  exit(EX_NOINPUT);
	}
    }

  /* open table file */
  if ( !strcmp(argv[2],"-") && in != stdin )
    {
      ctbl = stdin;
      tblname = "stdin";
    }
  else
    {
      ctbl = fopen(tblname = argv[2], "r");
      if ( !ctbl )
	{
	  perror(tblname);
	  exit(EX_NOINPUT);
	}
    }

  /* open output file */
  if ( argc < 4 || !strcmp(argv[3],"-") )
    out = stdout;
  else
    {
      out = fopen(argv[3], "w");
      if ( !out )
	{
	  perror(argv[3]);
	  exit(EX_CANTCREAT);
	}
    }

  if (-1 == psf_header_read (in, &psfhdr))
      perror("psf_header_read"), exit(EX_DATAERR);
  
  fontlen = ( PSF_MODE_HAS512(psfhdr.mode) ) ? 512 : 256;

  /* Copy font data */
  if ( fread(buffer, psfhdr.charheight, fontlen, in) < fontlen )
    {
      perror(inname);
      exit(EX_DATAERR);
    }
  fclose(in);			/* Done with input */

  /* Set has-table bit in mode field, and copy to output */

  if (PSF_MODE_HAS512(psfhdr.mode))
    psfhdr.mode = PSF_MODE512SFM;
  else
    psfhdr.mode = PSF_MODE256SFM;
  fwrite(&psfhdr, sizeof(struct psf_header), 1, out);
  fwrite(buffer, psfhdr.charheight, fontlen, out);

  if (NULL == (mapf = findsfm(tblname, pathname, sizeof(pathname),
			      stdin, NULL)))
      perror("findsfm"), exit (1);
  
  if (verbose) fprintf (stderr, "Loading unicode map from %s.\n", pathname);
  if (sfm_read_ascii (mapf, &map, fontlen))
      perror ("sfm_read_ascii"), exit (EX_DATAERR);
  
  /* Okay, now glyph table should be read */

  fclose(ctbl);

  sfm_write_binary (out, &map, fontlen);
      
  fclose(out);

  exit(EX_OK);
}
