/***************************************************************************
                          agbrowser.h  -  description
                             -------------------
    begin                : Mon Feb 26 00:27:08 EST 2001
    copyright            : (C) 2001 by Joe Theriault
    email                : uallloveme@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef AGBROWSER_H
#define AGBROWSER_H

#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qstack.h>
#include <qtabwidget.h>
#include <qvariant.h>
#include <qvbuttongroup.h>
#include <qwidget.h>

#include <kanimwidget.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kmainwindow.h>
#include <kprocess.h>
#include <ksystemtray.h>
#include <kurlrequester.h>

#include "agconfig.h"
#include "agsharemanager.h"
#include "agtray.h"

class AGBrowser : public KMainWindow
{
  Q_OBJECT

  public:
    AGBrowser( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~AGBrowser();

  signals:
    void AGconnected();
    void AGdisconnected();

  public slots:
    void goBack();
    void goForward();
    void goHome();
    void reload();
    void stop();
    void openURLRequest(const KURL &url, const KParts::URLArgs&);
    void addShares();
    void removeShares();
    void applySettings();
    void resetSettings();
    void completed();
    void clientDied();
    void connectAG();
    void disconnectAG();

  protected:
    void addPast();
    void addFuture();
    void fillSettingsForm();
    void readSettingsForm();
    void runSatellite();
    void manageMp3s();

  private:
    friend class AGTray;

    // Toplevel
    AGConfig*          agconfig;
    AGShareManager shareManager;
    AGTray*             trayView;
    QTabWidget*       mainView;
    QStack<KURL>* historyPast;
    QStack<KURL>* historyFuture;
    bool                    addToPast;
    bool                    clearFuture;
    KProcess*            client;
    bool                    shouldBeConnected;

    // AudioGalaxy webview tab
    QWidget* audiogalaxy_tab;
    KHTMLPart* webView;
    QPushButton* back_btn;
    QPushButton* forward_btn;
    QPushButton* home_btn;
    QPushButton* reload_btn;
    QPushButton* stop_btn;
    KAnimWidget* feedback_label;

    // Settings tab
    QWidget* settings_tab;
    QLabel* username_lbl;
    KLineEdit* username_edit;
    QLabel* password_lbl;
    KLineEdit* password_edit;
    QLabel* satelliteDir_lbl;
    KURLRequester* satelliteDir_kurlr;
    QLabel* downloadDir_lbl;
    KURLRequester* downloadDir_kurlr;
    QLabel* shares_lbl;
    KListBox* shared_list;
    QPushButton* add_share_btn;
    QPushButton* remove_share_btn;
    QCheckBox* connect_chk;
    QCheckBox* disconnect_chk;
    QLabel* home_lbl;
    QVButtonGroup* home_grp;
    QRadioButton* front_rad;
    QRadioButton* user_rad;
    QRadioButton* queue_rad;
    QLabel* font_lbl;
    KListBox* webViewFont_list;
    QFrame* settings_sep1;
    QPushButton* apply_btn;
    QFrame* settings_sep1_2;
    QPushButton* restore_btn;
};

#endif
