/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.aspectj.org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.builder.MissingClassFileException;
import org.aspectj.org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.SourceFile;
import org.aspectj.org.eclipse.jdt.internal.core.builder.State;
import org.aspectj.org.eclipse.jdt.internal.core.builder.WorkQueue;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractImageBuilder
implements ICompilerRequestor {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected ArrayList problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    public static int MAX_AT_ONCE = 1000;
    public static final String[] JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments"};
    public static final String[] JAVA_TASK_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "priority", "id", "charStart", "charEnd", "lineNumber", "arguments"};
    public static final Integer S_ERROR = new Integer(2);
    public static final Integer S_WARNING = new Integer(1);
    public static final Integer P_HIGH = new Integer(2);
    public static final Integer P_NORMAL = new Integer(1);
    public static final Integer P_LOW = new Integer(0);

    protected AbstractImageBuilder(JavaBuilder javaBuilder) {
        this.javaBuilder = javaBuilder;
        this.newState = new State(javaBuilder);
        this.nameEnvironment = javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.compiler = this.newCompiler();
        this.workQueue = new WorkQueue();
        this.problemSourceFiles = new ArrayList(3);
    }

    /*
     * Unable to fully structure code
     */
    public void acceptResult(CompilationResult result) {
        block15: {
            compilationUnit = (SourceFile)result.getCompilationUnit();
            if (this.workQueue.isCompiled(compilationUnit)) break block15;
            this.workQueue.finished(compilationUnit);
            try {
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
            if (result.hasInconsistentToplevelHierarchies && !this.problemSourceFiles.contains(compilationUnit)) {
                this.problemSourceFiles.add(compilationUnit);
            }
            mainType = null;
            mainTypeName = null;
            typeLocator = compilationUnit.typeLocator();
            classFiles = result.getClassFiles();
            length = classFiles.length;
            duplicateTypeNames = null;
            definedTypeNames = new ArrayList<char[]>(length);
            i = 0;
            while (i < length) {
                block17: {
                    block16: {
                        classFile = classFiles[i];
                        compoundName = classFile.getCompoundName();
                        typeName = compoundName[compoundName.length - 1];
                        v0 = isNestedType = classFile.enclosingClassFile != null;
                        if (!isNestedType) break block16;
                        qualifiedTypeName = new String(classFile.outerMostEnclosingClassFile().fileName());
                        if (!this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) ** GOTO lbl52
                        break block17;
                    }
                    qualifiedTypeName = new String(classFile.fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        if (duplicateTypeNames == null) {
                            duplicateTypeNames = new ArrayList<char[][]>();
                        }
                        duplicateTypeNames.add(compoundName);
                        if (mainType == null) {
                            try {
                                mainTypeName = compilationUnit.initialTypeName;
                                mainType = this.javaBuilder.javaProject.findType(mainTypeName.replace('/', '.'));
                            }
                            catch (JavaModelException var16_19) {
                                // empty catch block
                            }
                        }
                        if (qualifiedTypeName.equals(mainTypeName)) {
                            type = mainType;
                        } else {
                            simpleName = qualifiedTypeName.substring(qualifiedTypeName.lastIndexOf(47) + 1);
                            type = mainType == null ? null : mainType.getCompilationUnit().getType(simpleName);
                        }
                        this.createProblemFor(compilationUnit.resource, type, Messages.bind(Messages.build_duplicateClassFile, new String(typeName)), "error");
                    } else {
                        this.newState.recordLocatorForType(qualifiedTypeName, typeLocator);
lbl52:
                        // 2 sources

                        try {
                            definedTypeNames.add(this.writeClassFile(classFile, compilationUnit, isNestedType == false));
                        }
                        catch (CoreException e) {
                            Util.log(e, "JavaBuilder handling CoreException");
                            if (e.getStatus().getCode() == 275) {
                                this.createProblemFor(compilationUnit.resource, null, Messages.bind(Messages.build_classFileCollision, e.getMessage()), "error");
                            }
                            this.createProblemFor(compilationUnit.resource, null, Messages.build_inconsistentClassFile, "error");
                        }
                    }
                }
                ++i;
            }
            this.finishedWith(typeLocator, result, compilationUnit.getMainTypeName(), definedTypeNames, duplicateTypeNames);
            this.notifier.compiled(compilationUnit);
        }
    }

    protected void cleanUp() {
        this.nameEnvironment.cleanup();
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        int unitsLength = units.length;
        boolean bl = this.compiledAllAtOnce = unitsLength <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                int i = 0;
                while (i < unitsLength) {
                    System.out.println("About to compile " + units[i].typeLocator());
                    ++i;
                }
            }
            this.compile(units, null);
        } else {
            int i = 0;
            boolean compilingFirstGroup = true;
            while (i < unitsLength) {
                int doNow = unitsLength < MAX_AT_ONCE ? unitsLength : MAX_AT_ONCE;
                int index = 0;
                SourceFile[] toCompile = new SourceFile[doNow];
                while (i < unitsLength && index < doNow) {
                    SourceFile unit = units[i++];
                    if (!compilingFirstGroup && !this.workQueue.isWaiting(unit)) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("About to compile " + unit.typeLocator());
                    }
                    toCompile[index++] = unit;
                }
                if (index < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[index];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, index);
                }
                SourceFile[] additionalUnits = new SourceFile[unitsLength - i];
                System.arraycopy(units, i, additionalUnits, 0, additionalUnits.length);
                compilingFirstGroup = false;
                this.compile(toCompile, additionalUnits);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void compile(SourceFile[] units, SourceFile[] additionalUnits) {
        if (units.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(units[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int length;
            int toAdd = this.problemSourceFiles.size();
            int n = length = additionalUnits == null ? 0 : additionalUnits.length;
            if (length == 0) {
                additionalUnits = new SourceFile[toAdd];
            } else {
                SourceFile[] sourceFileArray = additionalUnits;
                additionalUnits = new SourceFile[length + toAdd];
                System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
            }
            int i = 0;
            while (i < toAdd) {
                additionalUnits[length + i] = (SourceFile)this.problemSourceFiles.get(i);
                ++i;
            }
        }
        String[] initialTypeNames = new String[units.length];
        int i = 0;
        int l = units.length;
        while (i < l) {
            initialTypeNames[i] = units[i].initialTypeName;
            ++i;
        }
        this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
        this.notifier.checkCancel();
        try {
            try {
                this.inCompiler = true;
                this.compiler.compile(units);
            }
            catch (AbortCompilation abortCompilation) {}
            Object var5_9 = null;
            this.inCompiler = false;
            this.notifier.checkCancel();
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.inCompiler = false;
            throw throwable;
        }
    }

    protected void createProblemFor(IResource resource, IMember javaElement, String message, String problemSeverity) {
        try {
            IMarker marker = resource.createMarker("org.aspectj.org.eclipse.jdt.core.problem");
            int severity = problemSeverity.equals("warning") ? 1 : 2;
            ISourceRange range = javaElement == null ? null : javaElement.getNameRange();
            int start = range == null ? 0 : range.getOffset();
            int end = range == null ? 1 : start + range.getLength();
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd"}, new Object[]{message, new Integer(severity), new Integer(start), new Integer(end)});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        if (duplicateTypeNames == null) {
            this.newState.record(sourceLocator, result.qualifiedReferences, result.simpleNameReferences, mainTypeName, definedTypeNames);
            return;
        }
        char[][][] qualifiedRefs = result.qualifiedReferences;
        char[][] simpleRefs = result.simpleNameReferences;
        int i = 0;
        int l = duplicateTypeNames.size();
        while (i < l) {
            block4: {
                char[][] compoundName = (char[][])duplicateTypeNames.get(i);
                char[] typeName = compoundName[compoundName.length - 1];
                int sLength = simpleRefs.length;
                int j = 0;
                while (j < sLength) {
                    if (!CharOperation.equals(simpleRefs[j], typeName)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                char[][] cArray = simpleRefs;
                simpleRefs = new char[sLength + 1][];
                System.arraycopy(cArray, 0, simpleRefs, 0, sLength);
                simpleRefs[sLength] = typeName;
            }
            ++i;
        }
        this.newState.record(sourceLocator, qualifiedRefs, simpleRefs, mainTypeName, definedTypeNames);
    }

    protected IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(true, true, null);
            folder.setDerived(true);
        }
        return folder;
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderException);
        }
        return imageBuilderException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Compiler newCompiler() {
        LookupEnvironment env;
        Map projectOptions = this.javaBuilder.javaProject.getOptions(true);
        String option = (String)projectOptions.get("org.aspectj.org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
        if (!(option != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.aspectj.org.eclipse.jdt.core.compiler.problem.missingJavadocTags")) != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.aspectj.org.eclipse.jdt.core.compiler.problem.missingJavadocComments")) != null && !option.equals("ignore") || (option = (String)projectOptions.get("org.aspectj.org.eclipse.jdt.core.compiler.problem.unusedImport")) != null && !option.equals("ignore"))) {
            projectOptions.put("org.aspectj.org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
        }
        Compiler newCompiler = new Compiler(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), projectOptions, this, ProblemFactory.getProblemFactory(Locale.getDefault()));
        CompilerOptions options = newCompiler.options;
        options.produceReferenceInfo = true;
        LookupEnvironment lookupEnvironment = env = newCompiler.lookupEnvironment;
        synchronized (lookupEnvironment) {
            env.sharedArraysUsed = false;
            env.sharedClassFileHeader = new byte[30000];
            env.sharedClassFileContents = new byte[30000];
        }
        return newCompiler;
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = this.sourceLocations.length;
        while (j < k) {
            if (childPath.equals(this.sourceLocations[j].binaryFolder.getFullPath())) {
                return true;
            }
            if (childPath.equals(this.sourceLocations[j].sourceFolder.getFullPath())) {
                return true;
            }
            ++j;
        }
        return childPath.equals(this.javaBuilder.javaProject.getOutputLocation());
    }

    protected void storeProblemsFor(SourceFile sourceFile, IProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        String missingClassFile = null;
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = problems.length;
        while (i < l) {
            IProblem problem = problems[i];
            int id = problem.getID();
            if (id == 0x1000144) {
                JavaBuilder.removeProblemsAndTasksFor(this.javaBuilder.currentProject);
                String[] args = problem.getArguments();
                missingClassFile = args[0];
            }
            if (id != 536871362) {
                IMarker marker = resource.createMarker("org.aspectj.org.eclipse.jdt.core.problem");
                marker.setAttributes(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES, new Object[]{problem.getMessage(), problem.isError() ? S_ERROR : S_WARNING, new Integer(id), new Integer(problem.getSourceStart()), new Integer(problem.getSourceEnd() + 1), new Integer(problem.getSourceLineNumber()), Util.getProblemArgumentsForMarker(problem.getArguments())});
            }
            if (missingClassFile != null) {
                throw new MissingClassFileException(missingClassFile);
            }
            ++i;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, IProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = tasks.length;
        while (i < l) {
            IProblem task = tasks[i];
            if (task.getID() == 536871362) {
                IMarker marker = resource.createMarker("org.aspectj.org.eclipse.jdt.core.task");
                Integer priority = P_NORMAL;
                String compilerPriority = task.getArguments()[2];
                if ("HIGH".equals(compilerPriority)) {
                    priority = P_HIGH;
                } else if ("LOW".equals(compilerPriority)) {
                    priority = P_LOW;
                }
                marker.setAttributes(JAVA_TASK_MARKER_ATTRIBUTE_NAMES, new Object[]{task.getMessage(), priority, new Integer(task.getID()), new Integer(task.getSourceStart()), new Integer(task.getSourceEnd() + 1), new Integer(task.getSourceLineNumber()), Boolean.FALSE});
            }
            ++i;
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] writeClassFile(ClassFile classFile, SourceFile compilationUnit, boolean isSecondaryType) throws CoreException {
        IContainer outputFolder;
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder = compilationUnit.sourceLocation.binaryFolder;
        if (filePath.segmentCount() > 1) {
            container = this.createFolder(filePath.removeLastSegments(1), outputFolder);
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileBytes(classFile.getBytes(), file, fileName, isSecondaryType, compilationUnit.updateClassFile);
        if (classFile.ownSharedArrays) {
            LookupEnvironment env;
            LookupEnvironment lookupEnvironment = env = this.compiler.lookupEnvironment;
            synchronized (lookupEnvironment) {
                env.sharedArraysUsed = false;
            }
        }
        return filePath.lastSegment().toCharArray();
    }

    protected void writeClassFileBytes(byte[] bytes, IFile file, String qualifiedFileName, boolean isSecondaryType, boolean updateClassFile) throws CoreException {
        if (file.exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing changed class file " + file.getName());
            }
            file.setContents(new ByteArrayInputStream(bytes), true, false, null);
            if (!file.isDerived()) {
                file.setDerived(true);
            }
        } else {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            file.create((InputStream)new ByteArrayInputStream(bytes), 1, null);
            file.setDerived(true);
        }
    }
}

