/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.core.runtime.IProgressMonitor;

public final class CompletionProposal
extends InternalCompletionProposal {
    private boolean updateCompletion = false;
    public static final int ANONYMOUS_CLASS_DECLARATION = 1;
    public static final int FIELD_REF = 2;
    public static final int KEYWORD = 3;
    public static final int LABEL_REF = 4;
    public static final int LOCAL_VARIABLE_REF = 5;
    public static final int METHOD_REF = 6;
    public static final int METHOD_DECLARATION = 7;
    public static final int PACKAGE_REF = 8;
    public static final int TYPE_REF = 9;
    public static final int VARIABLE_DECLARATION = 10;
    public static final int POTENTIAL_METHOD_DECLARATION = 11;
    public static final int METHOD_NAME_REFERENCE = 12;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private char[] completion = CharOperation.NO_CHAR;
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private char[] declarationSignature = null;
    private char[] name = null;
    private char[] signature = null;
    private int flags = 0;
    private char[][] parameterNames = null;
    private boolean parameterNamesComputed = false;

    public static CompletionProposal create(int kind, int completionOffset) {
        return new CompletionProposal(kind, completionOffset);
    }

    CompletionProposal(int kind, int completionLocation) {
        if (kind < 1 || kind > 12) {
            throw new IllegalArgumentException();
        }
        if (this.completion == null || completionLocation < 0) {
            throw new IllegalArgumentException();
        }
        this.completionKind = kind;
        this.completionLocation = completionLocation;
    }

    public int getKind() {
        return this.completionKind;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.tokenStart = startIndex;
        this.tokenEnd = endIndex;
    }

    public char[] getCompletion() {
        if (this.completionKind == 7) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length);
                    int start = 0;
                    int end = CharOperation.indexOf('%', this.completion);
                    completionBuffer.append(CharOperation.subarray(this.completion, start, end));
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = CharOperation.indexOf('%', this.completion, start);
                        if (end > -1) {
                            completionBuffer.append(CharOperation.subarray(this.completion, start, end));
                        } else {
                            completionBuffer.append(CharOperation.subarray(this.completion, start, this.completion.length));
                        }
                        ++i;
                    }
                    int nameLength = completionBuffer.length();
                    this.completion = new char[nameLength];
                    completionBuffer.getChars(0, nameLength, this.completion, 0);
                }
            }
        }
        return this.completion;
    }

    public void setCompletion(char[] completion) {
        this.completion = completion;
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int rating) {
        if (rating <= 0) {
            throw new IllegalArgumentException();
        }
        this.relevance = rating;
    }

    public char[] getDeclarationSignature() {
        return this.declarationSignature;
    }

    public void setDeclarationSignature(char[] signature) {
        this.declarationSignature = signature;
    }

    public char[] getName() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    public char[] getSignature() {
        return this.signature;
    }

    public void setSignature(char[] signature) {
        this.signature = signature;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public char[][] findParameterNames(IProgressMonitor monitor) {
        if (!this.parameterNamesComputed) {
            this.parameterNamesComputed = true;
            switch (this.completionKind) {
                case 1: {
                    this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, CharOperation.lastSegment(this.declarationTypeName, '.'), this.parameterPackageNames, this.parameterTypeNames);
                    break;
                }
                case 6: {
                    this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, this.name, this.parameterPackageNames, this.parameterTypeNames);
                    break;
                }
                case 7: {
                    this.parameterNames = this.findMethodParameterNames(this.declarationPackageName, this.declarationTypeName, this.name, this.parameterPackageNames, this.parameterTypeNames);
                    if (this.parameterNames == null) break;
                    this.updateCompletion = true;
                }
            }
        }
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
        this.parameterNamesComputed = true;
    }
}

