/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.extension;

import java.io.File;
import java.io.IOException;

/**
 * <p>Interface used to store a collection of "Optional Packages" 
 * (formerly known as "Standard Extensions"). It is assumed that each 
 * "Optional Package" is represented by a single file on the file system.</p>
 *
 * <p>This repository is responsible for storing the local repository of
 * packages. The method used to locate packages on local filesystem
 * and install packages is not specified.</p>
 *
 * <p>For more information about optional packages, see the document
 * <em>Optional Package Versioning</em> in the documentation bundle for your
 * Java2 Standard Edition package, in file
 * <code>guide/extensions/versioning.html</code></p>.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version $Revision: 1.5 $ $Date: 2001/12/11 09:53:34 $
 */
public interface PackageRepository
{
    /**
     * Return all the <code>OptionalPackage</code>s that satisfy specified
     * <code>Extension</code>. 
     *
     * @param extension Description of the extension that needs to be provided by 
     *                  optional packages
     * @see #getOptionalPackage()
     * @see OptionalPackage
     * @see Extension
     */
    OptionalPackage[] getOptionalPackages( Extension extension );
}
