/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n.test;

import java.util.Map;
import java.util.HashMap;
import java.util.Locale;
import java.net.URL;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.component.ComponentException;
import junit.framework.TestCase;

import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.excalibur.i18n.BundleMatcher;
import org.apache.avalon.excalibur.i18n.ConfigurableBundleInfo;

/**
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version $Id: DefaultBundleMatcherTestCase.java,v 1.4 2002/01/02 19:04:56 neeme Exp $
 */
public class DefaultBundleMatcherTestCase extends TestCase {

    private BundleMatcher[] matchers;

    public DefaultBundleMatcherTestCase(String name) {
        super(name);
    }

    public void configure(Configuration configuration) throws Exception {
        Configuration[] confs = configuration.getChildren("matcher");
        this.matchers = new BundleMatcher[confs.length];
        for (int i = 0; i < confs.length; i++) {
            this.matchers[i] = (BundleMatcher) Class.forName(confs[i].getAttribute("class")).newInstance();
            if (this.matchers[i] instanceof Configurable) ((Configurable) this.matchers[i]).configure(confs[i]);
        }
    }

    public void setUp() throws Exception {
        super.setUp();

        final String resourceName = this.getClass().getName().replace( '.', '/' ) + ".xtest";
        URL resource = this.getClass().getClassLoader().getResource( resourceName );
        final DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        final Configuration conf = builder.build( resource.openStream() );
        configure(conf);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.matchers = null;
    }

    public void testMatching() throws Exception {
        assertEquals("test1", matchers[0].getType(new BundleInfo("test", new Locale("test-lang", "test-country", "test-variant"), "test-ext")));
        assertTrue(null == matchers[0].getType(new BundleInfo("test", new Locale("test-lang", "test-country", "test-variant"), "test")));
        assertEquals("test2", matchers[1].getType(new BundleInfo("test", new Locale("test-lang", "test-country", "test-variant"))));
        assertTrue(null == matchers[1].getType(new BundleInfo("testing", new Locale("test-lang", "test-country", "test-variant"))));
        assertEquals("test3", matchers[2].getType(new BundleInfo("test", new Locale("test-lang", "test-country"))));
        assertTrue(null == matchers[2].getType(new BundleInfo("testing", new Locale("test-language", "test-country"))));
        assertTrue(null == matchers[2].getType(new BundleInfo("testing", new Locale("test-lang", "test-count"))));
    }

}
