/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private CacheFile cache_file;
    private String path;
    private String name;
    private String extension;
    private long length;
    private long downloaded;
    private int firstPieceNumber = -1;
    private int nbPieces = 0;
    private DiskManagerImpl diskManager;
    private TOTorrentFile torrent_file;
    private boolean priority = false;
    private boolean skipped = false;

    protected DiskManagerFileInfoImpl(DiskManagerImpl _disk_manager, File _file, TOTorrentFile _torrent_file) throws CacheFileManagerException {
        this.diskManager = _disk_manager;
        this.torrent_file = _torrent_file;
        try {
            this.path = String.valueOf(_file.getParentFile().getCanonicalPath()) + System.getProperty("file.separator");
            this.name = _file.getName();
        }
        catch (Exception e) {
            Debug.out("Unable to resolve canonical path for " + _file.getName());
            Debug.printStackTrace(e);
        }
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, _file);
    }

    public String getCacheFileOwnerName() {
        return this.diskManager.getName();
    }

    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    protected void moveFile(File newFile) throws CacheFileManagerException {
        this.cache_file.moveFile(newFile);
        try {
            this.path = String.valueOf(newFile.getParentFile().getCanonicalPath()) + System.getProperty("file.separator");
        }
        catch (Exception e) {
            Debug.out("Unable to resolve canonical path for " + newFile.getName());
        }
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        this.cache_file.setAccessMode(mode == 1 ? 1 : 2);
    }

    public int getAccessMode() {
        int mode = this.cache_file.getAccessMode();
        return mode == 1 ? 1 : 2;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getFile() {
        return this.cache_file.getFile();
    }

    public int getFirstPieceNumber() {
        return this.firstPieceNumber;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setFirstPieceNumber(int i) {
        this.firstPieceNumber = i;
    }

    public void setLength(long l) {
        this.length = l >= 0L ? l : 0L;
    }

    public void setNbPieces(int i) {
        this.nbPieces = i;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean b) {
        this.priority = b;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean _skipped) {
        this.skipped = _skipped;
    }

    public DiskManager getDiskManager() {
        return this.diskManager;
    }
}

