/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.util.Average;

public class PEPeerStatsImpl
implements PEPeerStats {
    private long totalReceived;
    private long totalSent;
    private long totalDiscarded;
    private long totalHave;
    private Average receptionSpeed = Average.getInstance(1000, 10);
    private Average chokingReceptionSpeed = Average.getInstance(1000, 20);
    private Average sendingSpeed = Average.getInstance(1000, 5);
    private Average overallSpeed = Average.getInstance(5000, 100);
    private Average statisticSentSpeed = Average.getInstance(3000, 60);

    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    public void received(int length) {
        this.totalReceived += (long)length;
        this.receptionSpeed.addValue(length);
        this.chokingReceptionSpeed.addValue(length);
    }

    public void sent(int length) {
        this.totalSent += (long)length;
        this.sendingSpeed.addValue(length);
    }

    public void protocol_sent(int length) {
    }

    public void haveNewPiece(int pieceLength) {
        this.totalHave += (long)pieceLength;
        this.overallSpeed.addValue(pieceLength);
    }

    public void statisticSent(int length) {
        this.statisticSentSpeed.addValue(length);
    }

    public long getDownloadAverage() {
        return this.receptionSpeed.getAverage();
    }

    public long getReception() {
        return this.chokingReceptionSpeed.getAverage();
    }

    public long getUploadAverage() {
        return this.sendingSpeed.getAverage();
    }

    public long getTotalDiscarded() {
        return this.totalDiscarded;
    }

    public long getBytesDone() {
        return this.totalHave;
    }

    public long getTotalSent() {
        return this.totalSent;
    }

    public long getTotalReceived() {
        return this.totalReceived;
    }

    public long getTotalAverage() {
        return this.overallSpeed.getAverage();
    }

    public long getStatisticSentAverage() {
        return this.statisticSentSpeed.getAverage();
    }
}

