/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.classic.TrackerStatus;

public class TRTrackerScraperResponseImpl
implements TRTrackerScraperResponse {
    protected byte[] hash;
    protected int seeds;
    protected int peers;
    private long scrapeStartTime;
    private long nextScrapeStartTime;
    private TrackerStatus ts;
    private String sStatus = "";
    private String sLastStatus = "";
    private int status;
    private int last_status;

    protected TRTrackerScraperResponseImpl(TrackerStatus _ts, byte[] _hash) {
        this(_ts, _hash, -1, -1, -1L);
    }

    protected TRTrackerScraperResponseImpl(TrackerStatus _ts, byte[] _hash, int _seeds, int _peers, long _scrapeStartTime) {
        this.hash = _hash;
        this.seeds = _seeds;
        this.peers = _peers;
        this.ts = _ts;
        this.scrapeStartTime = _scrapeStartTime;
        this.status = this.isValid() ? 0 : 2;
        this.nextScrapeStartTime = -1L;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public TrackerStatus getTrackerStatus() {
        return this.ts;
    }

    public int getSeeds() {
        return this.seeds;
    }

    public int getPeers() {
        return this.peers;
    }

    public void setSeedsPeers(int iSeeds, int iPeers) {
        this.seeds = iSeeds;
        this.peers = iPeers;
        this.status = this.isValid() ? 0 : 2;
        this.ts.scrapeReceived(this);
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int iNewStatus, String sNewStatus) {
        if (this.last_status != this.status && iNewStatus != this.status) {
            this.last_status = this.status;
        }
        this.status = iNewStatus == 2 ? (this.isValid() ? 0 : 2) : iNewStatus;
        if (sNewStatus == null) {
            return;
        }
        if (!this.sLastStatus.equals(this.sStatus)) {
            this.sLastStatus = this.sStatus;
        }
        this.sStatus = sNewStatus;
    }

    protected void revertStatus() {
        this.status = this.last_status;
        this.sStatus = this.sLastStatus;
    }

    public void setScrapeStartTime(long time) {
        this.scrapeStartTime = time;
    }

    public long getScrapeStartTime() {
        return this.scrapeStartTime;
    }

    public long getNextScrapeStartTime() {
        return this.nextScrapeStartTime;
    }

    public void setNextScrapeStartTime(long nextScrapeStartTime) {
        this.nextScrapeStartTime = nextScrapeStartTime;
    }

    public String getStatusString() {
        return this.sStatus;
    }

    public boolean isValid() {
        return this.seeds != -1 || this.peers != -1;
    }
}

