/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateInstallerImpl;

public class UpdateManagerImpl
implements UpdateManager {
    protected static UpdateManagerImpl singleton;
    protected AzureusCore azureus_core;
    protected List components = new ArrayList();
    protected List listeners = new ArrayList();
    protected List installers = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("UpdateManager");

    public static UpdateManager getSingleton(AzureusCore core) {
        if (singleton == null) {
            singleton = new UpdateManagerImpl(core);
        }
        return singleton;
    }

    protected UpdateManagerImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        UpdateInstallerImpl.checkForFailedInstalls();
        try {
            PlatformManagerFactory.getPlatformManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        try {
            this.this_mon.enter();
            this.components.add(new UpdatableComponentImpl(component, mandatory));
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UpdateCheckInstance createUpdateCheckInstance() {
        return this.createUpdateCheckInstance(2, "");
    }

    public UpdateCheckInstance createUpdateCheckInstance(int type, String name) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[this.components.size()];
            this.components.toArray(comps);
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            int i = 0;
            while (i < this.listeners.size()) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
                ++i;
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            this.this_mon.exit();
            return updateCheckInstanceImpl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateCheckInstance createEmptyUpdateCheckInstance(int type, String name) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[]{};
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            int i = 0;
            while (i < this.listeners.size()) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
                ++i;
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            this.this_mon.exit();
            return updateCheckInstanceImpl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        UpdateInstallerImpl installer = new UpdateInstallerImpl();
        this.installers.add(installer);
        return installer;
    }

    public UpdateInstaller[] getInstallers() {
        UpdateInstaller[] res = new UpdateInstaller[this.installers.size()];
        this.installers.toArray(res);
        return res;
    }

    public void restart() throws UpdateException {
        this.applyUpdates(true);
    }

    public void applyUpdates(boolean restart_after) throws UpdateException {
        try {
            if (restart_after) {
                this.azureus_core.requestRestart();
            } else {
                this.azureus_core.requestStop();
            }
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateManager:applyUpdates fails", e);
        }
    }

    public void addListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }
}

