/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.impl.GlobalManagerAdpater;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class UserAlerts {
    private AudioClip audio_clip = null;
    private String audio_resource = "";
    private AEMonitor this_mon = new AEMonitor("UserAlerts");
    static /* synthetic */ Class class$0;

    public UserAlerts(GlobalManager global_manager) {
        final DownloadManagerAdapter download_manager_listener = new DownloadManagerAdapter(){

            public void downloadComplete(DownloadManager manager) {
                UserAlerts.this.downloadFinished();
            }
        };
        global_manager.addListener(new GlobalManagerAdpater(){

            public void downloadManagerAdded(DownloadManager manager) {
                manager.addListener(download_manager_listener);
            }

            public void downloadManagerRemoved(DownloadManager removed) {
                removed.removeListener(download_manager_listener);
            }

            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        });
    }

    protected void downloadFinished() {
        block20: {
            try {
                try {
                    this.this_mon.enter();
                    if (!COConfigurationManager.getBooleanParameter("Play Download Finished", false)) break block20;
                    String file = COConfigurationManager.getStringParameter("Play Download Finished File");
                    if ((file = file.trim()).startsWith("<")) {
                        file = "";
                    }
                    if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                        this.audio_clip = null;
                        if (file.length() != 0) {
                            File f = new File(file);
                            try {
                                try {
                                    if (f.exists()) {
                                        URL file_url = f.toURL();
                                        this.audio_clip = Applet.newAudioClip(file_url);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            finally {
                                if (this.audio_clip == null) {
                                    LGLogger.logUnrepeatableAlert(3, "Failed to load audio file '" + file + "'");
                                }
                            }
                        }
                        if (this.audio_clip == null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.gudy.azureus2.ui.common.util.UserAlerts");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.audio_clip = Applet.newAudioClip(clazz.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                        }
                        this.audio_resource = file;
                    }
                    if (this.audio_clip != null) {
                        new AEThread("DownloadSound"){

                            public void runSupport() {
                                try {
                                    UserAlerts.this.audio_clip.play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            int i = 0;
            while (i < threadList.length) {
                if (threadList[i] != null && "Java Sound event dispatcher".equals(threadList[i].getName())) {
                    threadList[i].interrupt();
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

