/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.FileFilter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.OpenUrlWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;

public class TorrentOpener {
    private static Display display;
    private static Shell mainWindow;
    private static GlobalManager globalManager;

    public static void init(Shell _mainWindow, GlobalManager gm) {
        display = SWTThread.getInstance().getDisplay();
        mainWindow = _mainWindow;
        globalManager = gm;
    }

    public static void openTorrent(AzureusCore azureus_core, String fileName) {
        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        TorrentOpener.openTorrent(azureus_core, fileName, default_start_stopped, false);
    }

    public static void openTorrent(final AzureusCore azureus_core, final String fileName, final boolean startInStoppedState, boolean from_drag_and_drop) {
        int https_index;
        int http_index = fileName.toUpperCase().lastIndexOf("HTTP:");
        int index = Math.max(http_index, https_index = fileName.toUpperCase().lastIndexOf("HTTPS:"));
        if (index > -1) {
            String url = fileName.substring(index);
            url = url.replace('\\', '/');
            int root_index = url.indexOf(58) + 1;
            while (url.charAt(root_index) == '/') {
                ++root_index;
            }
            url = url.substring(root_index);
            String protocol = http_index > -1 ? "http://" : "https://";
            final String full_url = String.valueOf(protocol) + url;
            AERunnable r = new AERunnable(){

                public void runSupport() {
                    TorrentOpener.openUrl(azureus_core, full_url);
                }
            };
            display.asyncExec((Runnable)r);
            return;
        }
        try {
            if (!FileUtil.isTorrentFile(fileName) && from_drag_and_drop) {
                LGLogger.log("MainWindow::openTorrent: file it not a torrent file, sharing");
                ShareUtils.shareFile(azureus_core, fileName);
                return;
            }
        }
        catch (Exception e) {
            LGLogger.log("MainWindow::openTorrent: check fails", e);
            return;
        }
        if (display != null && !display.isDisposed()) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    new AEThread(this, "TorrentOpener::openTorrent", fileName, startInStoppedState){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ String val$fileName;
                        private final /* synthetic */ boolean val$startInStoppedState;
                        {
                            this.this$1 = var1_1;
                            this.val$fileName = string;
                            this.val$startInStoppedState = bl;
                            super($anonymous0);
                        }

                        public void runSupport() {
                            try {
                                String savePath = TorrentOpener.getSavePath(this.val$fileName);
                                if (savePath == null) {
                                    LGLogger.log("MainWindow::openTorrent: save path not set, aborting");
                                    return;
                                }
                                LGLogger.log("MainWindow::openTorrent: adding download '" + this.val$fileName + "' --> '" + savePath + "'");
                                try {
                                    TorrentOpener.access$0().addDownloadManager(this.val$fileName, savePath, this.val$startInStoppedState ? 70 : 0);
                                }
                                catch (Throwable e) {
                                    LGLogger.logUnrepeatableAlert("Torrent open fails for '" + this.val$fileName + "'", e);
                                }
                            }
                            catch (Throwable e) {
                                LGLogger.log("MainWindow::openTorrent: torrent addition fails", e);
                            }
                        }
                    }.start();
                }
            });
        }
    }

    public static String getSavePath(String fileName) {
        return TorrentOpener.getSavePathSupport(fileName, true, false);
    }

    protected static String getSavePathSupport(String fileName, boolean useDefault, boolean forSeeding) {
        File f;
        boolean has_default = COConfigurationManager.getBooleanParameter("Use default data dir");
        final String[] default_dir = new String[]{COConfigurationManager.getStringParameter("Default save path")};
        if (default_dir[0] == null || default_dir[0].length() == 0) {
            has_default = false;
        }
        if (has_default && !(f = new File(default_dir[0])).exists()) {
            f.mkdirs();
        }
        if (!useDefault || !has_default) {
            boolean singleFile = false;
            String singleFileName = "";
            try {
                TOTorrent torrent = TorrentUtils.readFromFile(new File(fileName), false);
                singleFile = torrent.isSimpleTorrent();
                LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(torrent);
                singleFileName = locale_decoder.decodeString(torrent.getName());
                singleFileName = FileUtil.convertOSSpecificChars(singleFileName);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            final boolean f_singleFile = singleFile;
            final boolean f_forSeeding = forSeeding;
            final String f_singleFileName = singleFileName;
            final AESemaphore sem = new AESemaphore("TorrentOpener");
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    try {
                        if (f_singleFile) {
                            int style = f_forSeeding ? 4096 : 8192;
                            FileDialog fDialog = new FileDialog(mainWindow, 0x20000 | style);
                            fDialog.setFilterPath(TorrentOpener.getFilterPathData());
                            fDialog.setFileName(f_singleFileName);
                            fDialog.setText(String.valueOf(MessageText.getString("MainWindow.dialog.choose.savepath")) + " (" + f_singleFileName + ")");
                            default_dir[0] = TorrentOpener.setFilterPathData(fDialog.open());
                        } else {
                            DirectoryDialog dDialog = new DirectoryDialog(mainWindow, 131072);
                            dDialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dDialog.setText(String.valueOf(MessageText.getString("MainWindow.dialog.choose.savepath")) + " (" + f_singleFileName + ")");
                            default_dir[0] = TorrentOpener.setFilterPathData(dDialog.open());
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            });
            sem.reserve();
        }
        return default_dir[0];
    }

    protected static void openTorrents(String path, String[] fileNames) {
        TorrentOpener.openTorrents(path, fileNames, true);
    }

    protected static void openTorrentsForSeeding(String path, String[] fileNames) {
        TorrentOpener.openTorrents(path, fileNames, false, true);
    }

    protected static void openTorrents(String path, String[] fileNames, boolean useDefault) {
        TorrentOpener.openTorrents(path, fileNames, useDefault, false);
    }

    protected static void openTorrents(final String path, final String[] fileNames, final boolean useDefault, final boolean forSeeding) {
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                new AEThread(this, "TorrentOpener", fileNames, path, useDefault, forSeeding){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ String[] val$fileNames;
                    private final /* synthetic */ String val$path;
                    private final /* synthetic */ boolean val$useDefault;
                    private final /* synthetic */ boolean val$forSeeding;
                    {
                        this.this$1 = var1_1;
                        this.val$fileNames = stringArray;
                        this.val$path = string;
                        this.val$useDefault = bl;
                        this.val$forSeeding = bl2;
                        super($anonymous0);
                    }

                    public void runSupport() {
                        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
                        String separator = System.getProperty("file.separator");
                        int i = 0;
                        while (i < this.val$fileNames.length) {
                            String savePath = TorrentOpener.getSavePathSupport(String.valueOf(this.val$path) + separator + this.val$fileNames[i], this.val$useDefault, this.val$forSeeding);
                            if (savePath != null) {
                                try {
                                    TorrentOpener.access$0().addDownloadManager(String.valueOf(this.val$path) + separator + this.val$fileNames[i], savePath, default_start_stopped ? 70 : 75, true, this.val$forSeeding);
                                }
                                catch (Throwable e) {
                                    LGLogger.logUnrepeatableAlert("Torrent open fails for '" + this.val$path + separator + this.val$fileNames[i] + "'", e);
                                }
                            }
                            ++i;
                        }
                    }
                }.start();
            }
        });
    }

    public static void openTorrentsFromDirectory(String directoryName) {
        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        TorrentOpener.openTorrentsFromDirectory(directoryName, default_start_stopped);
    }

    public static void openTorrentsFromDirectory(String directoryName, final boolean startInStoppedState) {
        File f = new File(directoryName);
        if (!f.isDirectory()) {
            return;
        }
        final File[] files = f.listFiles(new FileFilter(){

            public boolean accept(File arg0) {
                if (FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".torrent")) {
                    return true;
                }
                return FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".tor");
            }
        });
        if (files.length == 0) {
            return;
        }
        DirectoryDialog dDialog = new DirectoryDialog(mainWindow, 0);
        dDialog.setFilterPath(TorrentOpener.getFilterPathData());
        dDialog.setText(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
        final String path = TorrentOpener.setFilterPathData(dDialog.open());
        if (path == null) {
            return;
        }
        new AEThread("Torrent Opener"){

            public void runSupport() {
                int i = 0;
                while (i < files.length) {
                    try {
                        globalManager.addDownloadManager(files[i].getAbsolutePath(), path, startInStoppedState ? 70 : 75);
                    }
                    catch (Throwable e) {
                        LGLogger.logUnrepeatableAlert("Torrent open fails for '" + files[i].getAbsolutePath() + "'", e);
                    }
                    ++i;
                }
            }
        }.start();
    }

    public static void openDirectory() {
        DirectoryDialog fDialog = new DirectoryDialog(mainWindow, 0);
        fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
        fDialog.setText(MessageText.getString("MainWindow.dialog.choose.folder"));
        String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
        if (path == null) {
            return;
        }
        TorrentOpener.openTorrentsFromDirectory(path);
    }

    public static void openTorrent() {
        FileDialog fDialog = new FileDialog(mainWindow, 4098);
        fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
        fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", "*.*"});
        fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", "*.*"});
        fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
        String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
        if (path == null) {
            return;
        }
        TorrentOpener.openTorrents(path, fDialog.getFileNames());
    }

    public static void openTorrentNoDefaultSave(boolean forSeeding) {
        FileDialog fDialog = new FileDialog(mainWindow, 4098);
        fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
        fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", "*.*"});
        fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", "*.*"});
        fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
        String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
        if (path == null) {
            return;
        }
        TorrentOpener.openTorrents(path, fDialog.getFileNames(), false, forSeeding);
    }

    public static void openTorrentWindow() {
        new OpenTorrentWindow(display, globalManager);
    }

    public static void openUrl(AzureusCore azureus_core) {
        TorrentOpener.openUrl(azureus_core, null);
    }

    public static void openUrl(AzureusCore azureus_core, String linkURL) {
        if (linkURL != null && linkURL.length() > 12 && COConfigurationManager.getBooleanParameter("Add URL Silently")) {
            new FileDownloadWindow(azureus_core, display, linkURL, null);
        } else {
            new OpenUrlWindow(azureus_core, display, linkURL, null);
        }
    }

    public static void openDroppedTorrents(AzureusCore azureus_core, DropTargetEvent event) {
        if (event.data == null) {
            return;
        }
        if (event.data instanceof String[]) {
            String[] sourceNames = (String[])event.data;
            if (sourceNames == null) {
                event.detail = 0;
            }
            if (event.detail == 0) {
                return;
            }
            boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
            boolean startInStoppedState = default_start_stopped || event.detail == 1;
            int i = 0;
            while (i < sourceNames.length) {
                File source = new File(sourceNames[i]);
                if (source.isFile()) {
                    TorrentOpener.openTorrent(azureus_core, source.getAbsolutePath(), startInStoppedState, true);
                } else if (source.isDirectory()) {
                    String dir_name = source.getAbsolutePath();
                    String drop_action = COConfigurationManager.getStringParameter("config.style.dropdiraction", "0");
                    if (drop_action.equals("1")) {
                        ShareUtils.shareDir(azureus_core, dir_name);
                    } else if (drop_action.equals("2")) {
                        ShareUtils.shareDirContents(azureus_core, dir_name, false);
                    } else if (drop_action.equals("3")) {
                        ShareUtils.shareDirContents(azureus_core, dir_name, true);
                    } else {
                        TorrentOpener.openTorrentsFromDirectory(dir_name, startInStoppedState);
                    }
                }
                ++i;
            }
        } else {
            TorrentOpener.openUrl(azureus_core, ((URLTransfer.URLType)event.data).linkURL);
        }
    }

    public static String getFilterPathData() {
        File f;
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.data");
        if (before != null && before.length() > 0) {
            return before;
        }
        String def = COConfigurationManager.getStringParameter("Default save path");
        if (def != null && def.length() > 0 && !(f = new File(def)).exists()) {
            f.mkdirs();
        }
        return def;
    }

    public static String getFilterPathTorrent() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent");
        if (before != null && before.length() > 0) {
            return before;
        }
        return COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
    }

    public static String setFilterPathData(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.data")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.data", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String setFilterPathTorrent(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.torrent", now);
                COConfigurationManager.save();
            }
            return now;
        }
        return path;
    }
}

