/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ShareRatioItem
extends CoreTableColumn
implements TableCellRefreshListener,
ParameterListener {
    private static final String CONFIG_ID = "StartStopManager_iFirstPriority_ShareRatio";
    private int iMinShareRatio;

    public ShareRatioItem(String sTableID) {
        super("shareRatio", 2, -2, 70, sTableID);
        this.setRefreshInterval(-2);
        if (sTableID.equals("MySeeders")) {
            this.setPosition(-2);
        } else {
            this.setPosition(-1);
        }
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addParameterListener(CONFIG_ID, this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CONFIG_ID, this);
    }

    public void refresh(TableCell cell) {
        int sr;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int n = sr = dm == null ? 0 : dm.getStats().getShareRatio();
        if (sr == -1) {
            sr = 31536000;
        }
        if (!cell.setSortValue(sr) && cell.isValid()) {
            return;
        }
        String shareRatio = "";
        if (sr == 31536000) {
            shareRatio = "\u221e";
        } else {
            String partial = String.valueOf(sr % 1000);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            shareRatio = String.valueOf(sr / 1000) + "." + partial;
        }
        if (cell.setText(shareRatio)) {
            ((TableCellCore)cell).setForeground((Color)(sr < this.iMinShareRatio ? Colors.colorWarning : null));
        }
    }

    public void parameterChanged(String parameterName) {
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        this.invalidateCells();
    }
}

