/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.layout.client;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;

class LayoutImpl {
    private static DivElement fixedRuler = LayoutImpl.createRuler(Style.Unit.CM, Style.Unit.CM);
    protected DivElement relativeRuler;

    LayoutImpl() {
    }

    protected static DivElement createRuler(Style.Unit widthUnit, Style.Unit heightUnit) {
        DivElement ruler = Document.get().createDivElement();
        ruler.setInnerHTML("&nbsp;");
        Style style = ruler.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(-32767);
        style.setTop(-20.0, heightUnit);
        style.setWidth(10.0, widthUnit);
        style.setHeight(10.0, heightUnit);
        return ruler;
    }

    public Element attachChild(Element parent, Element child, Element before) {
        DivElement container = Document.get().createDivElement();
        container.appendChild(child);
        container.getStyle().setPosition(Style.Position.ABSOLUTE);
        container.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.fillParent(child);
        Element beforeContainer = null;
        if (before != null) {
            beforeContainer = before.getParentElement();
            assert (beforeContainer.getParentElement() == parent) : "Element to insert before must be a sibling";
        }
        parent.insertBefore(container, beforeContainer);
        return container;
    }

    public void fillParent(Element elem) {
        Style style = elem.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(0.0, Style.Unit.PX);
        style.setTop(0.0, Style.Unit.PX);
        style.setRight(0.0, Style.Unit.PX);
        style.setBottom(0.0, Style.Unit.PX);
    }

    public void finalizeLayout(Element parent) {
    }

    public double getUnitSizeInPixels(Element parent, Style.Unit unit, boolean vertical) {
        if (unit == null) {
            return 1.0;
        }
        switch (unit) {
            case PCT: {
                return (double)(vertical ? parent.getClientHeight() : parent.getClientWidth()) / 100.0;
            }
            case EM: {
                return (double)this.relativeRuler.getOffsetWidth() / 10.0;
            }
            case EX: {
                return (double)this.relativeRuler.getOffsetHeight() / 10.0;
            }
            case CM: {
                return (double)fixedRuler.getOffsetWidth() * 0.1;
            }
            case MM: {
                return (double)fixedRuler.getOffsetWidth() * 0.01;
            }
            case IN: {
                return (double)fixedRuler.getOffsetWidth() * 0.254;
            }
            case PT: {
                return (double)fixedRuler.getOffsetWidth() * 0.00353;
            }
            case PC: {
                return (double)fixedRuler.getOffsetWidth() * 0.0423;
            }
        }
        return 1.0;
    }

    public void initParent(Element parent) {
        parent.getStyle().setPosition(Style.Position.RELATIVE);
        this.relativeRuler = LayoutImpl.createRuler(Style.Unit.EM, Style.Unit.EX);
        parent.appendChild(this.relativeRuler);
    }

    public void layout(Layout.Layer layer) {
        Style style = layer.container.getStyle();
        if (layer.visible) {
            style.clearDisplay();
        } else {
            style.setDisplay(Style.Display.NONE);
        }
        style.setProperty("left", layer.setLeft ? layer.left + layer.leftUnit.getType() : "");
        style.setProperty("top", layer.setTop ? layer.top + layer.topUnit.getType() : "");
        style.setProperty("right", layer.setRight ? layer.right + layer.rightUnit.getType() : "");
        style.setProperty("bottom", layer.setBottom ? layer.bottom + layer.bottomUnit.getType() : "");
        style.setProperty("width", layer.setWidth ? layer.width + layer.widthUnit.getType() : "");
        style.setProperty("height", layer.setHeight ? layer.height + layer.heightUnit.getType() : "");
        style = layer.child.getStyle();
        switch (layer.hPos) {
            case BEGIN: {
                style.setLeft(0.0, Style.Unit.PX);
                style.clearRight();
                break;
            }
            case END: {
                style.clearLeft();
                style.setRight(0.0, Style.Unit.PX);
                break;
            }
            case STRETCH: {
                style.setLeft(0.0, Style.Unit.PX);
                style.setRight(0.0, Style.Unit.PX);
            }
        }
        switch (layer.vPos) {
            case BEGIN: {
                style.setTop(0.0, Style.Unit.PX);
                style.clearBottom();
                break;
            }
            case END: {
                style.clearTop();
                style.setBottom(0.0, Style.Unit.PX);
                break;
            }
            case STRETCH: {
                style.setTop(0.0, Style.Unit.PX);
                style.setBottom(0.0, Style.Unit.PX);
            }
        }
    }

    public void onAttach(Element parent) {
    }

    public void onDetach(Element parent) {
    }

    public void removeChild(Element container, Element child) {
        container.removeFromParent();
        if (child.getParentElement() == container) {
            child.removeFromParent();
        }
        Style style = child.getStyle();
        style.clearPosition();
        style.clearLeft();
        style.clearTop();
        style.clearWidth();
        style.clearHeight();
    }

    static {
        Document.get().getBody().appendChild(fixedRuler);
    }
}

