//
// Copyright 1999 Craig Spannring
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All advertising materials mentioning features or use of this software
//    must display the following acknowledgement:
//      This product includes software developed by Craig Spannring
// 4. The name of Craig Spannring may not be used to endorse or promote
//    products derived from this software without specific prior
//    written permission.
//
// THIS SOFTWARE IS PROVIDED BY CRAIG SPANNRING ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL CRAIG SPANNRING BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
package com.internetcds.jdbc.tds;

import java.sql.*;


public class CallableStatement_2_0 
   extends    com.internetcds.jdbc.tds.CallableStatement_base
   implements java.sql.CallableStatement
{
   public static final String cvsVersion = "$Id: CallableStatement_2_0.java,v 1.3 2000/07/17 04:41:03 cts Exp $";


   public CallableStatement_2_0(
      java.sql.Connection conn_, 
      Tds                 tds_, 
      String              sql)
      throws java.sql.SQLException
   {
      super(conn_, tds_, sql);
   }


   /**
    * JDBC 2.0
    *
    * Gets the value of a JDBC <code>BLOB</code> parameter as a
    * {@link Blob} object in the Java programming language.
    * @param i the first parameter is 1, the second is 2, and so on
    * @return the parameter value as a <code>Blob</code> object in the
    * Java programming language.  If the value was SQL NULL, the value
    * <code>null</code> is returned.
    * @exception SQLException if a database access error occurs
    */
   public Blob getBlob (int i) throws SQLException
   {
      NotImplemented();
      return null;
   }
   
   /**
    * JDBC 2.0
    *
    * Gets the value of a JDBC <code>CLOB</code> parameter as a
    * <code>Clob</code> object in the Java programming language.
    * @param i the first parameter is 1, the second is 2, and
    * so on
    * @return the parameter value as a <code>Clob</code> object in the
    * Java programming language.  If the value was SQL NULL, the
    * value <code>null</code> is returned.
    * @exception SQLException if a database access error occurs
    */
   public Clob getClob (int i) throws SQLException
   {
      NotImplemented();
      return null;
   }

   
   /**
    * JDBC 2.0
    *
    * Returns an object representing the value of OUT parameter 
    * <code>i</code> and uses <code>map</code> for the custom
    * mapping of the parameter value.
    * <p>
    * This method returns a Java object whose type corresponds to the
    * JDBC type that was registered for this parameter using the method
    * <code>registerOutParameter</code>.  By registering the target
    * JDBC type as <code>java.sql.Types.OTHER</code>, this method can
    * be used to read database-specific abstract data types.  
    * @param i the first parameter is 1, the second is 2, and so on
    * @param map the mapping from SQL type names to Java classes
    * @return a java.lang.Object holding the OUT parameter value.
    * @exception SQLException if a database access error occurs
    */
   public Object  getObject (int i, java.util.Map map) throws SQLException
   {
      NotImplemented();
      return null;
   }

   
   /**
    * JDBC 2.0
    *
    * Gets the value of a JDBC <code>REF(&lt;structured-type&gt;)</code>
    * parameter as a {@link Ref} object in the Java programming language.
    * @param i the first parameter is 1, the second is 2, 
    * and so on
    * @return the parameter value as a <code>Ref</code> object in the
    * Java programming language.  If the value was SQL NULL, the value
    * <code>null</code> is returned.
    * @exception SQLException if a database access error occurs
    */
   public Ref getRef (int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   /**
    * JDBC 2.0
    *
    * Gets the value of a JDBC <code>ARRAY</code> parameter as an
    * {@link Array} object in the Java programming language.
    * @param i the first parameter is 1, the second is 2, and 
    * so on
    * @return the parameter value as an <code>Array</code> object in
    * the Java programming language.  If the value was SQL NULL, the
    * value <code>null</code> is returned.
    * @exception SQLException if a database access error occurs
    */
   public Array getArray (int i) throws SQLException
   {
      NotImplemented();
      return null;
   }


   public void setClob (int i, java.sql.Clob x) throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void addBatch() throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void setBlob (int i, java.sql.Blob x) throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void setArray (int i, java.sql.Array x) throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }


   public void setRef (int i, java.sql.Ref x) throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }


   public void setCharacterStream(int parameterIndex,
                                  java.io.Reader reader,
                                  int length) throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public java.sql.ResultSetMetaData getMetaData() throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
      return null;
   }
   public void setNull (int paramIndex, int sqlType, String typeName) 
      throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void setTimestamp(int parameterIndex, java.sql.Timestamp x, java.util.Calendar cal)
      throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void setDate(int parameterIndex, java.sql.Date x, java.util.Calendar cal)
      throws java.sql.SQLException
   {
      //  XXX should be inherited PreparedStatement_2_0
      NotImplemented();
   }

   public void setTime(int parameterIndex, java.sql.Time x, java.util.Calendar cal) 
      throws java.sql.SQLException
   {
      NotImplemented();
   }

}
