  
import java.sql.*;
import java.io.*;


/**
 * test getting timestamps from the database.
 *
 */
public class t0001
{
   static public boolean check(
      ResultSet   rs,
      Timestamp   expected1, 
      Timestamp   expected2, 
      Timestamp   expected3, 
      Timestamp   expected4)
      throws java.sql.SQLException
   {
      rs.next();
   
      Timestamp   t1 = rs.getTimestamp(1);
      Timestamp   t2 = rs.getTimestamp(2);
      Timestamp   t3 = rs.getTimestamp(3);
      Timestamp   t4 = rs.getTimestamp(4);
      
      System.out.println("Result set-");
      System.out.println("   got " + t1 + ", expected " + expected1);
      System.out.println("   got " + t2 + ", expected " + expected2);
      System.out.println("   got " + t3 + ", expected " + expected3);
      System.out.println("   got " + t4 + ", expected " + expected4);
      return true;
   }

   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, IOException
   {
      boolean   passed = true;


      System.out.println("Starting test t0001-  Insert and retrieve timestamps");



      // open the database
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0001");
      }
      catch (SQLException e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }

      
      count = stmt.executeUpdate("create table t0001             " +
                                 "  (t1 datetime not null,       " +
                                 "   t2 datetime null,           " +
                                 "   t3 smalldatetime not null,  " +
                                 "   t4 smalldatetime null)");
      System.out.println("Creating table affected " + count + " rows");


      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0001 values (?, '1998-03-09 15:35:05.4',        " +
         "                          ?, '1998-03-09 15:35:00')");
      Timestamp   t0 = new Timestamp(98, 2, 9, 15, 35, 6, 400000000);
      Timestamp   t1 = new Timestamp(98, 2, 9, 15, 35, 0, 0);


      pStmt.setTimestamp(1, t0);
      pStmt.setTimestamp(2, t0);
      count = pStmt.executeUpdate();
      System.out.println("Added " + count + " rows");
    
      pStmt = cx.prepareStatement(
         "select t1, t2, t3, t4 from t0001");
    
      ResultSet  rs1 = stmt.executeQuery("select t1, t2, t3, t4 "+
                                         " from t0001           ");


      check(rs1, t0, t0, t1, t1);
// if (false)

//  {

//       ResultSet  rs2 = pStmt.executeQuery();
    
//       System.out.println("Should be");
//       System.out.println("   " + t0);
//       System.out.println("   1998-09-09 15:35:06");
//       System.out.println("   1998-09-09 15:35:05");
//       System.out.println("   now");
//       System.out.println("   1998-09-09 15:35:00");

//       if (!rs1.next())
//       {
//          System.out.println("stmt did not get any results.");
//       }
//       System.out.println("Statement result");
//       System.out.println("   t0 is " + t0);
//       System.out.println("   t1 is " + t1);
//       System.out.println("   t2 is " + t2);
//       System.out.println("   t3 is " + t3);
//       System.out.println("   t4 is " + t4);


//       if (!rs2.next())
//       {
//          System.out.println("stmt did not get any results.");
//       }
//       t1 = rs2.getTimestamp(1);
//       t2 = rs2.getTimestamp(2);
//       t3 = rs2.getTimestamp(3);
//       t4 = rs2.getTimestamp(4);
//       System.out.println("PreparedStatement result");
//       System.out.println("   t0 is " + t0);
//       System.out.println("   t1 is " + t1);
//       System.out.println("   t2 is " + t2);
//       System.out.println("   t3 is " + t3);
//       System.out.println("   t4 is " + t4);




//    }


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0001.\n");
      System.exit(passed ? 0 : 1);
   }
}

