
import java.sql.*;


/**
 * test ResultSetMetaData.isReadonly, ResultSetMetaData.isNullable,
 *      ResultSetMetaData.isAutoIncrement
 *
 */
public class t0046
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;


      System.out.println("test isReadonly(), isNullable(), isAutoIncrement()");


      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0046");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0046', because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate(""
                                 + "create table t0046                  "
                                 + "(                                   "
                                 + "   i    integer identity,           "
                                 + "   a    integer not null,           "
                                 + "   b    integer null                "
                                 + ")                                   ");
      System.out.println("Creating table affected " + count + " rows");
      
      count = stmt.executeUpdate("insert into t0046 (a, b) values (-2, -3)");
      passed = passed && count == 1;


      String             queryString = ("select i, a, b, 17 c from t0046");
      ResultSet          rs = stmt.executeQuery(queryString);
      ResultSetMetaData  md = rs.getMetaData();

      passed = passed && (md != null);
      System.out.println("checked md.  passed is " + passed);

      passed = passed && (md.isAutoIncrement(1));
      passed = passed && (! md.isAutoIncrement(2));
      passed = passed && (! md.isAutoIncrement(3));
      passed = passed && (! md.isAutoIncrement(4));
      System.out.println("checked isAutoIncrement.  passed is " + passed);

      passed = passed && (md.isReadOnly(1));
      passed = passed && (! md.isReadOnly(2));
      passed = passed && (! md.isReadOnly(3));
      // Constants are handled consistently between SQLServer 6.5 and 7.0
      //      passed = passed && (md.isReadOnly(4));
      System.out.println("checked isReadOnly.  passed is " + passed);

      passed = passed && (md.isNullable(1) == java.sql.ResultSetMetaData.columnNoNulls);
      passed = passed && (md.isNullable(2) == java.sql.ResultSetMetaData.columnNoNulls);
      passed = passed && (md.isNullable(3) == java.sql.ResultSetMetaData.columnNullable);
      // Constants are handled consistently between SQLServer 6.5 and 7.0
      //      passed = passed && (md.isNullable(4) == java.sql.ResultSetMetaData.columnNoNulls);
      System.out.println("checked isNullable.  passed is " + passed);


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0046.\n");
      System.exit(passed ? 0 : 1);
   }
}

