/* GSnes9x -- main.c: Main window & initialization functions.
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsnes9x.h"

/* For use in the worst case. */
/* It's not a variable! :) */
static char * black_xpm[] = {
	"10 10 2 1",
	" 	c None",
	".	c #000000",
	"..........",
	"..........",
	"..........",
	"..........",
	"..........",
	"..........",
	"..........",
	"..........",
	"..........",
	".........."
};

int
main (gint argc, gchar *argv[])
{
	F_NAME();
	
	gnome_init (PACKAGE, VERSION, argc, argv);
	
#ifdef ENABLE_NLS
	setlocale (LC_CTYPE, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
#endif

	gdk_imlib_init ();
	
	gnome_window_icon_set_default_from_file ("/usr/share/pixmaps/gsnes9x-icon.png");

	main_window (gsnes9x_init ());

	gtk_main ();

	return 0;
}

void
main_window (GlobalPrefs *prefs)
{
	gchar       *status;
	GtkWidget   *vbox;
	GtkWidget   *hsep;
	GSnes9xData *data = gsnes9x_data_new ();

	F_NAME();
	
	data->prefs     = prefs;
	data->roms_list = g_list_first (get_roms_list ());
	data->app       = gnome_app_new (PACKAGE, PACKAGE);
	data->status    = gtk_label_new ("");
	
	gtk_misc_set_alignment (GTK_MISC (data->status), 0, 0.5);
	
	gtk_object_set_data (GTK_OBJECT (data->app), "gsnes_data",
			     (gpointer) data);
	gtk_widget_realize (data->app);
	gtk_signal_connect (GTK_OBJECT (data->app), "delete_event",
			    GTK_SIGNAL_FUNC (quit_by_close_cb), NULL);

	data->paned = gtk_hpaned_new ();
	
	get_roms_window  (data);
	get_image_window (data);

	gtk_paned_add1 (GTK_PANED (data->paned), data->roms_w);
	gtk_paned_add2 (GTK_PANED (data->paned), data->image_w);

	vbox = gtk_vbox_new (FALSE, 0);
	hsep = gtk_hseparator_new ();

	gtk_box_pack_start (GTK_BOX (vbox), data->paned,  TRUE, TRUE,   0);
	gtk_box_pack_start (GTK_BOX (vbox), hsep,         FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), data->status, FALSE, FALSE, 0);
	
	gnome_app_set_contents (GNOME_APP (data->app), vbox);

	create_menus (data);

	gtk_widget_show (data->image_w);
	gtk_widget_show (data->roms_w);
	gtk_widget_show (data->paned);
	gtk_widget_show (hsep);
	gtk_widget_show (data->status);
	gtk_widget_show (data->app);

	gtk_widget_grab_focus (data->clist);
	
	status = g_strdup_printf (_("Total ROMs: %d"),
				  g_list_length (g_list_first
						 (data->roms_list)));
	gtk_label_set_text (GTK_LABEL (data->status), status);
	g_free (status);
	
	gtk_signal_connect (GTK_OBJECT (data->image_w), "draw",
			    GTK_SIGNAL_FUNC (resize_pixmap_cb),
			    (gpointer) data);
}

GlobalPrefs*
gsnes9x_init ()
{
	GlobalPrefs *prefs = g_new (GlobalPrefs, 1);

	F_NAME();
	
	prefs = read_conf_file ();
	
	if (!prefs->string_prefs[SNES9X_COMMAND-ROM_STR_PREFS]) {
		g_warning (_("The global configuration file is"
			     "corrupt or incomplete. Recreating "
			     "it with default values."));
		g_free (prefs);
		create_conf_file ();
		return gsnes9x_init ();
	}

	return prefs;
}

void
get_roms_window (GSnes9xData *gsnes_data)
{
	F_NAME();
	
	gsnes_data->roms_w = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(gsnes_data->roms_w),
					GTK_POLICY_NEVER,
					GTK_POLICY_AUTOMATIC);
	
	gsnes_data->clist = get_list_roms (gsnes_data);
	
	gtk_signal_connect (GTK_OBJECT (gsnes_data->clist), "select_row",
			    GTK_SIGNAL_FUNC (select_rom_cb),
			    (gpointer) gsnes_data);

	gtk_signal_connect (GTK_OBJECT (gsnes_data->clist),
			    "button-release-event",
			    GTK_SIGNAL_FUNC (right_select_rom_cb),
			    (gpointer) gsnes_data);
	
	gtk_signal_connect (GTK_OBJECT (gsnes_data->clist), "key-press-event",
			    GTK_SIGNAL_FUNC (press_key_cb),
			    (gpointer) gsnes_data);

	gtk_container_add (GTK_CONTAINER (gsnes_data->roms_w),
			   gsnes_data->clist);

	gtk_widget_show (gsnes_data->clist);

	gtk_widget_set_usize (gsnes_data->roms_w,
			      IMAGE_WIDTH+20,
			      IMAGE_HEIGHT+20);
}

void
get_image_window (GSnes9xData *gsnes_data)
{
	F_NAME();
	
	gsnes_data->image_w = gtk_scrolled_window_new (NULL, NULL);
	
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(gsnes_data->image_w),
					GTK_POLICY_NEVER,
					GTK_POLICY_NEVER);

	gsnes_data->pixmap = get_image_pixmap (DEFAULT_IMAGE,
					       IMAGE_WIDTH,
					       IMAGE_HEIGHT);

	gtk_signal_connect (GTK_OBJECT (gsnes_data->image_w),
			    "button-press-event",
			    GTK_SIGNAL_FUNC (right_click_pixmap_cb),
			    (gpointer) gsnes_data);

        gtk_scrolled_window_add_with_viewport (
		GTK_SCROLLED_WINDOW (gsnes_data->image_w),
		gsnes_data->pixmap);
        
        gtk_widget_show (gsnes_data->pixmap);

        gtk_widget_set_usize (gsnes_data->image_w,
                              IMAGE_WIDTH+20,
                              IMAGE_HEIGHT+20);
}

GtkWidget*
get_list_roms (GSnes9xData *data)
{
	guint       i, num;
	GList      *list = data->roms_list;
	GtkWidget  *clist;
	gchar     **row;

	F_NAME();

	row = g_new (gchar*, 1);
	
	list  = g_list_first  (list);
	num   = g_list_length (list);
	clist = gtk_clist_new (1);

	gtk_clist_set_selection_mode (GTK_CLIST (clist),
				      GTK_SELECTION_SINGLE);
	gtk_clist_set_auto_sort (GTK_CLIST (clist), TRUE);
	
	for (i = 0; i < num; i++) {
		row[0] = g_strdup
			(((ROMInfo*)(list->data))->string_prefs[NAME]);
		gtk_clist_append (GTK_CLIST (clist), row);
		list = g_list_next (list);
		g_free (row[0]);
	}
	
	g_free (row);
	
	return clist;
}

GtkWidget*
get_image_pixmap (gchar *file, gint width, gint height)
{
	GtkWidget	*pixmap;
	
	F_NAME();
	
	pixmap = gnome_pixmap_new_from_file_at_size (file, width, height);
	
	if (!pixmap) {
		g_warning (_("Image file \"%s\" is not a valid image\n"
			     "or does not exist. Using \"%s\" instead."),
			   file, DEFAULT_IMAGE);
		pixmap = gnome_pixmap_new_from_file_at_size (DEFAULT_IMAGE, width, height);
		if (!pixmap) {
			g_warning (_("I can't find \"%s\"."), DEFAULT_IMAGE);
			pixmap = gnome_pixmap_new_from_xpm_d_at_size (black_xpm, width, height);
		}
	}

	return pixmap;
}

void
create_menus (GSnes9xData *gsnes_data)
{
	GtkWidget     *popmenu     = gtk_menu_new();
	GtkWidget     *play_item   =
		gtk_menu_item_new_with_label (_("Play ROM"));
	GtkWidget     *remove_item =
		gtk_menu_item_new_with_label (_("Remove ROM"));
	GtkWidget     *prefs_item  =
		gtk_menu_item_new_with_label (_("ROM Preferences"));
	GtkWidget     *tb;
	GnomeDockItem *item;

	GnomeUIInfo filemenu[] = {
		{ GNOME_APP_UI_ITEM,
		  _("_Play ROM"), _("Play SNES ROM"),
		  play_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
		  'P', GDK_CONTROL_MASK, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("_Add new ROM"), _("Add new ROM to the list"),
		  add_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
		  'N', GDK_CONTROL_MASK, NULL },
		{ GNOME_APP_UI_ITEM,
		  _("Re_move ROM"), _("Remove ROM from the list"),
		  remove_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
		  'D', GDK_CONTROL_MASK, NULL },
		{ GNOME_APP_UI_ITEM,
		  _("_ROM Preferences"), _("ROM Preferences"),
		  rom_preferences_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
		  'R', GDK_CONTROL_MASK, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("_Global Preferences"), _("Global Preferences"),
		  global_preferences_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
		  'G', GDK_CONTROL_MASK, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("_Quit"), _("Quit GSnes9x"),
		  quit_by_menu_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT,
		  'Q', GDK_CONTROL_MASK, NULL },
		GNOMEUIINFO_END
	};

	GnomeUIInfo helpmenu[] = {
		GNOMEUIINFO_HELP ("GSnes9x"),
		{ GNOME_APP_UI_ITEM,
		  _("Snes9X _README"), _("Original Snes9X Documentation"),
		  readme_cb, (gpointer)(0), NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE,
		  0, 0, NULL },
		{ GNOME_APP_UI_ITEM, 
		  _("_About"), _("Info about this program"),
		  about_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
		  0, 0, NULL },
		GNOMEUIINFO_END
	};
	
	GnomeUIInfo mainmenu[] = {
		{ GNOME_APP_UI_SUBTREE, _("_File"), NULL,
		  &filemenu, NULL, NULL, GNOME_APP_PIXMAP_NONE,
		  NULL, 0, 0, NULL },
		{ GNOME_APP_UI_SUBTREE, _("_Help"), NULL,
		  &helpmenu, NULL, NULL, GNOME_APP_PIXMAP_NONE,
		  NULL, 0, 0, NULL },
		GNOMEUIINFO_END
	};
	
	GnomeUIInfo toolbar[] = {
		{ GNOME_APP_UI_ITEM,
		  _("Play ROM"), _("Play SNES ROM"),
		  play_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_FORWARD,
		  0, 0, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("Add new ROM"), _("Add new ROM to the list"),
		  add_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW,
		  0, 0, NULL },
		{ GNOME_APP_UI_ITEM,
		  _("Remove ROM"), _("Remove ROM from the list"),
		  remove_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE,
		  0, 0, NULL },
		{ GNOME_APP_UI_ITEM,
		  _("ROM Preferences"), _("ROM Preferences"),
		  rom_preferences_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PROPERTIES,
		  0, 0, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("Global Preferences"), _("Global Preferences"),
		  global_preferences_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PREFERENCES,
		  0, 0, NULL },
		GNOMEUIINFO_SEPARATOR,
		{ GNOME_APP_UI_ITEM,
		  _("Quit"), _("Quit GSnes9x"),
		  quit_by_menu_cb, (gpointer) gsnes_data, NULL,
		  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_QUIT,
		  0, 0, NULL },
		GNOMEUIINFO_END
	};

	F_NAME();

	gtk_menu_append (GTK_MENU (popmenu), play_item);
	gtk_menu_append (GTK_MENU (popmenu), remove_item);
	gtk_menu_append (GTK_MENU (popmenu), prefs_item);
	gtk_widget_show (play_item);
	gtk_widget_show (remove_item);
	gtk_widget_show (prefs_item);

	gtk_menu_attach_to_widget (GTK_MENU(popmenu), gsnes_data->clist,
				   popup_menu_detacher);
	
	gtk_signal_connect_object (GTK_OBJECT (gsnes_data->clist), "destroy",
				   GTK_SIGNAL_FUNC (gtk_menu_detach),
				   GTK_OBJECT (popmenu));
	
	gtk_signal_connect (GTK_OBJECT (play_item), "activate",
			    GTK_SIGNAL_FUNC (play_cb),
			    (gpointer) gsnes_data);
	gtk_signal_connect (GTK_OBJECT (remove_item), "activate",
			    GTK_SIGNAL_FUNC (remove_cb),
			    (gpointer) gsnes_data);
	gtk_signal_connect (GTK_OBJECT (prefs_item), "activate",
			    GTK_SIGNAL_FUNC (rom_preferences_cb),
			    (gpointer) gsnes_data);
	
	gnome_app_create_menus   (GNOME_APP (gsnes_data->app), mainmenu);
	gnome_app_create_toolbar (GNOME_APP (gsnes_data->app), toolbar);
 
	item = gnome_app_get_dock_item_by_name (GNOME_APP (gsnes_data->app),
						GNOME_APP_TOOLBAR_NAME);
	tb = gnome_dock_item_get_child (item);  

	gtk_toolbar_set_style (GTK_TOOLBAR (tb),
			       GTK_TOOLBAR_ICONS);

	gsnes_data->popmenu = popmenu;
}

/* main.c ends here. */
