package Ifeffit::Plugins::Filetype::Athena::SSRL;  # -*- cperl -*-


=head1 NAME

Ifeffit::Plugin::Filetype::Athena::SSRL - SSRL XAFS Data Collector 1.1 filetype plugin

=head1 SYNOPSIS

This plugin directly reads the files written by the SSRL XAFS Data Collector.

=head1 BESSRC files

This plugin comments out the header lines, constructs a column label line out
of the Data: section, strips out the first column, and swaps the requested and
acheived energy columns.

=head1 AUTHOR

  Bruce Ravel <bravel@anl.gov>
  http://cars9.uchicago.edu.edu/~ravel/software/exafs/
  Athena copyright (c) 2001-2006

=cut

use vars qw(@ISA @EXPORT @EXPORT_OK);
use Exporter;
use File::Basename;
use File::Copy;
@ISA = qw(Exporter AutoLoader);
@EXPORT_OK = qw();

use vars qw($is_binary $description);
$is_binary = 0;
$description = "Read files from the SSRL XAFS Data Collector 1.1.";




sub is {
  shift;
  my $data = shift;
  open D, $data or die "could not open $data as data (SSRL)\n";
  my $line = <D>;
  close D, return 1 if ($line =~ /^\s*SSRL\s+EXAFS Data Collector/);
  return 0;
};

sub fix {
  shift;
  my ($data, $stash_dir, $top, $r_hash) = @_;
  my ($nme, $pth, $suffix) = fileparse($data);
  my $new = File::Spec->catfile($stash_dir, $nme);
  ($new = File::Spec->catfile($stash_dir, "toss")) if (length($new) > 127);
  open D, $data or die "could not open $data as data (fix in BESSRC)\n";
  open N, ">".$new or die "could not write to $new (fix in BESSRC)\n";
  my @labels = ();
  my @offsets = ();
  my ($header, $labels) = (1, 0);
  while (<D>) {
    chomp;
    if ($_ =~ /^\s*Data:/) {
      (($header, $labels) = (0,1));
      next;
    };
    if ($_ =~ /^\s*$/) {
      (($header, $labels) = (0,0));
      @labels = ($labels[2], $labels[1], @labels[3..$#labels]);
      print N "# ", "-"x30, $/;
      print N "# ", join(" ", @labels), $/;
      next;
    };
    if ($labels) {
      my $this = $_;
      $this =~ s/\s+$//;
      $this =~ s/\s+/_/g;
      push @labels, $this;
    } elsif ($header) {		# comment header
      if ($_ =~ /^\s*Offsets/) {
	print N "# ", $_, $/;
	my $line = <D>;
	@offsets = split(" ", $line);
	@offsets = ($offsets[2], $offsets[1], @offsets[3..$#offsets]);
	print N "# ", join(" ", @offsets), $/;
      } else {
	print N "# ", $_, $/;
      };
    } else {			# data columns
      my @line = split(" ", $_);
      @line = ($line[2], $line[1], @line[3..$#line]);
      my $pattern = "%.8f " x $#line . $/;
      #@line = map{ $line[$_] - $offsets[$_] } (0 .. $#line);
      printf N $pattern, @line;
    };
  };
  close N;
  close D;
  return $new;
}


1;
__END__
