/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.net.URL;
import org.apache.log4j.helpers.LogLog;

public class Loader {
    static String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";

    public static URL getResource(String resource, Class clazz) {
        URL url = null;
        LogLog.debug("Trying to find [" + resource + "] using Class.getResource().");
        try {
            url = clazz.getResource(resource);
            if (url != null) {
                return url;
            }
        }
        catch (Throwable t) {
            LogLog.warn(TSTR, t);
        }
        String fullyQualified = Loader.resolveName(resource, clazz);
        LogLog.debug("Trying to find [" + fullyQualified + "] using ClassLoader.getSystemResource().");
        url = ClassLoader.getSystemResource(fullyQualified);
        if (url != null) {
            return url;
        }
        ClassLoader loader = clazz.getClassLoader();
        if (loader != null) {
            try {
                LogLog.debug("Trying to find [" + resource + "] using " + loader + " class loader.");
                url = loader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            catch (Throwable t) {
                LogLog.warn(TSTR, t);
            }
        }
        LogLog.debug("Trying to find [" + resource + "] using ClassLoader.getSystemResource().");
        url = ClassLoader.getSystemResource(resource);
        return url;
    }

    static String resolveName(String resource, Class clazz) {
        String fqcn = clazz.getName();
        int index = fqcn.lastIndexOf(46);
        if (index != -1) {
            fqcn = fqcn.substring(0, index).replace('.', '/');
            resource = fqcn + "/" + resource;
        }
        return resource;
    }
}

