/* 
 *   Creation Date: <1999/03/20 07:30:18 samuel>
 *   Time-stamp: <2000/06/18 01:27:33 samuel>
 *   
 *	<blk_shared.h>
 *	
 *	Native MOL Block Driver MacOS - linux shared header
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 */
 
#ifndef _BLK_SHARED_
#define _BLK_SHARED_

/* Remember that this file is included *both* in linux and MacOS. Make sure
 * the structure elements has decent alignement to avoid problems.
 */ 

typedef struct DriveInfoOSI
{
	unsigned long	num_blocks;		/* # 512 bytes blocks */
	unsigned long	linux_id;

	int				locked;
} DriveInfoOSI;


/**********************************************************************
*	I/O queue & linux communcation
***********************************************************************/

#define IOPREP_PTAB_SIZE	32		/* == 128 K */

typedef struct 
{
	unsigned long	paddr, size;
} phys_block_t;


typedef struct BlkQueueEntry
{
	/* These fields are used for linux communication */
#ifdef LINUX_COMPILE
	struct BlkQueueEntry	*lnext;
	unsigned long		linux_private[3];
#else
	unsigned long		linux_private[4];
#endif	
	unsigned long		id;			/* IOCommandID */
	int			unit_id;
	int			is_write;

	unsigned long		blk_start;		/* starting block */
	unsigned long		seek_offs;		/* offset to data */
	
	int			io_done;		/* set to 1 when finished */
	int			err;			/* error if non-zero */

	int			ptab_count;
	phys_block_t		ptab[ IOPREP_PTAB_SIZE ];

	/* The following fields are private to the mac-side */
#ifndef LINUX_COMPILE
	IOCommandKind		ioCommandKind;
	
	unsigned long		qe_mphys;		/* mphys of this struct */
	IOParam			*pb;

	unsigned long		curCount;
	
	IOPreparationTable	ioPrept;
	unsigned long		phystable[ IOPREP_PTAB_SIZE ];

	OSStatus		immediateErr;		/* error code for immediate commands */
	struct BlkQueueEntry 	*next;
#endif
} BlkQueueEntry, *BlkQueuePtr;


#endif
