/* 
 *   Creation Date: <2001/06/21 14:27:13 samuel>
 *   Time-stamp: <2001/06/21 18:17:48 samuel>
 *   
 *	<misc.S>
 *	
 *	Miscellaneous
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include "asmdefs.h"
#include "multiplexer.h"

/************************************************************************/
/*	Kernel interface						*/
/************************************************************************/

GLOBL(fast_multiplexer):	
	li      r0,__NR_multiplexer
	sc
	blr

/************************************************************************/
/*	Timebase access							*/
/************************************************************************/

/* ullong get_mticks_( void ) */
GLOBL(get_mticks_):
1:	mftbu	r3
	mftbl	r4
	mftbu	r5
	cmpw	r3,r5
	bne	1b
	blr
		
/************************************************************************/
/*	Cache flushing							*/
/************************************************************************/

#define CACHE_LINE_SIZE		32
#define LG_CACHE_LINE_SIZE	5

/* flush_dcache_range( ulong start, ulong stop) */
GLOBL(flush_dcache_range):
	li	r5,CACHE_LINE_SIZE-1
	andc	r3,r3,r5
	subf	r4,r3,r4
	add	r4,r4,r5
	srwi.	r4,r4,LG_CACHE_LINE_SIZE
	beqlr
	mtctr	r4

1:	dcbst	0,r3
	addi	r3,r3,CACHE_LINE_SIZE
	bdnz	1b
	sync                            /* wait for dcbst's to get to ram */
	blr

/* flush_icache_range( ulong start, ulong stop) */
GLOBL(flush_icache_range):
        li      r5,CACHE_LINE_SIZE-1
        andc    r3,r3,r5
        subf    r4,r3,r4
        add     r4,r4,r5
        srwi.   r4,r4,LG_CACHE_LINE_SIZE
        beqlr
        mtctr   r4
        mr      r6,r3
1:      dcbst   0,r3
        addi    r3,r3,CACHE_LINE_SIZE
        bdnz    1b
        sync                            /* wait for dcbst's to get to ram */
        mtctr   r4
2:      icbi    0,r6
        addi    r6,r6,CACHE_LINE_SIZE
        bdnz    2b
        sync                            /* additional sync needed on g4 */
        isync
        blr
