/* 
 *   Creation Date: <2001/01/31 21:02:05 samuel>
 *   Time-stamp: <2001/06/21 18:05:55 samuel>
 *   
 *	<molcpu.h>
 *	
 *	
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_MOLCPU
#define _H_MOLCPU

#include "wrapper.h"

extern ulong g_session_magic;

/* Exports from mainloop.c and molcpu.c */

/* init / cleanup */
extern void	mainloop_init( void );
extern void	mainloop_cleanup( void );
extern void	mainloop_start( void );

extern void	molcpu_init( void );
extern void	molcpu_cleanup( void );

/* Emulation support */
extern void	irq_exception( void );
extern void	dec_exception( void );

/* interrupt emulation plays a central role in MOL */
extern void	interrupt_emulation();

/* flow control, mostly for the debugger */
extern void	stop_emulation( void );
extern void	resume_emulation( void );
extern void	quit_emulation( void );
extern void	save_session( void );

/* Debugger support */
extern void	set_break_flag( int flag );
extern void	clear_break_flag( int flag );

/* For mmu_cmds */
extern void	soft_trap( int trap_num );

/* In a few cases we need to know whether the *physical* processor is a 601 or not */
static inline int not_a_601( void ) {
	static int cached=-1;
	if( cached < 0 ) {
		ulong pvr;
		_get_pvr(&pvr);
		cached = !((pvr >> 16) == 1);
	}
	return cached;
}

#define is_a_601() (!not_a_601())

extern struct mac_regs *mregs;

#endif   /* _H_CPU_CONTROL */
