/* 
 *   Creation Date: <2000/08/06 01:27:53 samuel>
 *   Time-stamp: <2001/09/22 14:20:57 samuel>
 *   
 *	<compat.h>
 *	
 *	Kernel Compatibility Definitions
 *   
 *   Copyright (C) 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_COMPAT
#define _H_COMPAT

#include <linux/version.h>
#ifndef __ASSEMBLY__
#include <asm/atomic.h>
#include <linux/sched.h>	/* needed by <asm/mmu_context.h> */
#include <asm/mmu_context.h>
#include <asm/time.h>
#include "molif.h"
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#define LINUX_24
#endif

#ifndef __ASSEMBLY__

// We detect Paul's new MM implementation by the absence of MUNGE_CONTEXT
// The linux-MM change was introduced in 2.4.6
#ifndef MUNGE_CONTEXT
#define NEW_LINUX_MM
#endif


// Symbols exported from the module molsymglueN.o 
extern ulong 		msym_flush_hash_page, msym_handle_mm_fault, msym_next_mmu_context;
extern molif_t		mol_interface;		/* exported by old, patched kernels */

struct vm_area_struct;
struct mm_struct;
struct task_struct;
struct _PTE;

extern ulong		*mc_flush_hash_page;
extern atomic_t		*mc_next_mmu_context;
extern molif_t		*mc_molif;
#ifdef LINUX_24
extern int		(*mc_handle_mm_fault)( struct mm_struct *mm, 
					    struct vm_area_struct *vma,
					    unsigned long addr, int write_access);
#else
extern int		(*mc_handle_mm_fault)( struct task_struct *tsk, 
					    struct vm_area_struct *vma,
					    unsigned long addr, int write_access );
extern ulong		mc_giveup_altivec;
#endif /* LINUX_24 */

extern int linux_vers;

#ifdef LINUX_24
#define compat_clear_page(x)	clear_page( (void*)(x) );
#else
#define compat_clear_page(x)	clear_page( x );
#endif

#ifdef LINUX_24
extern inline void _tlbie(unsigned long va) 
{
        asm volatile ("tlbie %0" : : "r"(va));
}
#endif

// The mmap mm->mmap_sem semaphore changed in 2.4.3-pre5 from
// semaphore to rw_semaphore.

extern void _compat_mmap_sem_up( void *sem );
extern void _compat_mmap_sem_down( void *sem );

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
 #define MMAP_SEM_UP(x)		up(x)
 #define MMAP_SEM_DOWN(x)	down(x)
#else
 #define MMAP_SEM_UP(x)		_compat_mmap_sem_up(x)
 #define MMAP_SEM_DOWN(x)	_compat_mmap_sem_down(x)
#endif


// atomic_add_return is not exported in 2.2.

#ifdef LINUX_24 
#define compat_atomic_add_return(a,v) atomic_add_return(a,v)
#else
static __inline__ int compat_atomic_add_return(int a, atomic_t *v) {
        int t;

        __asm__ __volatile__("\n\
1:      lwarx   %0,0,%3\n\
        add     %0,%2,%0\n\
        stwcx.  %0,0,%3\n\
        bne-    1b"
        : "=&r" (t), "=m" (v->counter)
        : "r" (a), "r" (v), "m" (v->counter)
        : "cc");

        return t;
}
#endif

#ifdef LINUX_24
#define CURRENT_MM  (current->mm)
#else
/* Use CURRENT_MM instead of current->mm. This makes the MOL module 
 * less kernel version dependent. If the module is compiled with the 
 * correct headers, __current_mm_offs will always contain the correct offset.
 */
#define CURRENT_MM  (*(struct mm_struct**)((char*)current + __current_mm_offs ))
extern int __current_mm_offs;
#endif

#ifdef LINUX_24
#define compat_clear_page_reserved( ptr )	ClearPageReserved( virt_to_page(ptr))
#define compat_set_page_reserved( ptr ) 	SetPageReserved( virt_to_page(ptr) )
#else
#define compat_clear_page_reserved( ptr )	clear_bit( PG_reserved, &mem_map[MAP_NR(ptr)].flags );
#define compat_set_page_reserved( ptr ) 	set_bit( PG_reserved, &mem_map[MAP_NR(ptr)].flags )
#endif
#endif	/* __ASSEMBLY__ */

#ifdef LINUX_24
#define get_tb_frequency() 	( tb_ticks_per_jiffy * HZ )
#else
#define get_tb_frequency() 	0	/* not available on 2.2 */
#endif


#endif   /* _H_COMPAT */
