/*
 *	prefs.h
 */

#ifndef PREFS_H
#define PREFS_H

#ifdef __cplusplus
extern "C" {
#endif

OSErr init_app_spec (void);
OSErr blank_prefs (penguin_config *prefs);
OSErr write_prefs (FSSpec *spec, penguin_config *prefs);
OSErr read_prefs (FSSpec *spec, penguin_config *prefs);

OSErr add_ramdisk_bits_v1 (short file, penguin_config *prefs);
OSErr add_logfile_bits_v1 (short file, penguin_config *prefs);
OSErr add_penguin_bits_v1 (short file, penguin_config *prefs);
OSErr add_serial_bits_v1 (short file, penguin_config *prefs);
OSErr add_serial_prefs_v1 (short file, penguin_config *prefs);
OSErr add_boot_delay_prefs (short file, penguin_config *prefs);
OSErr add_command_line (short file, penguin_config *prefs);

OSErr get_ramdisk_bits_v1 (short file, penguin_config *prefs);
OSErr get_logfile_bits_v1 (short file, penguin_config *prefs);
OSErr get_penguin_bits_v1 (short file, penguin_config *prefs);
OSErr get_serial_bits_v1 (short file, penguin_config *prefs);
OSErr get_serial_prefs_v1 (short file, penguin_config *prefs);
OSErr get_boot_delay_prefs (short file, penguin_config *prefs);
OSErr get_command_line (short file, penguin_config *prefs);

OSErr find_prefs_tag (short file, long tag, long *position);

OSErr init_prefs (penguin_config *prefs);
OSErr save_prefs_as_default (penguin_config *prefs);

OSErr switch_to_kerneltab (DialogPtr dialog, penguin_config * prefs);
void do_item_kerneltab (short which_item, DialogPtr dialog, penguin_config * prefs);
void switch_from_kerneltab (DialogPtr dialog, penguin_config * prefs);

OSErr switch_to_optionstab (DialogPtr dialog, penguin_config * prefs);
void do_item_optionstab (short which_item, DialogPtr dialog, penguin_config * prefs);
void switch_from_optionstab (DialogPtr dialog, penguin_config * prefs);

OSErr switch_to_serialtab (DialogPtr dialog, penguin_config * prefs);
void do_item_serialtab (short which_item, DialogPtr dialog, penguin_config * prefs);
void switch_from_serialtab (DialogPtr dialog, penguin_config * prefs);


#ifdef __cplusplus
}
#endif

#endif
