//******************************************************************************
//
// File:    Program1Clu.java
// Package: ---
// Unit:    Class Program1Clu
//
// This Java source file is copyright (C) 2007 by Alan Kaminsky. All rights
// reserved. For further information, contact the author, Alan Kaminsky, at
// ark@cs.rit.edu.
//
// This Java source file is part of the Parallel Java Library ("PJ"). PJ is free
// software; you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
//
// PJ is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
// A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
// A copy of the GNU General Public License is provided in the file gpl.txt. You
// may also obtain a copy of the GNU General Public License on the World Wide
// Web at http://www.gnu.org/licenses/gpl.html.
//
//******************************************************************************

import edu.rit.pj.Comm;

/**
 * Class Program1Clu is the cluster parallel version of the first program
 * illustrating parallel computing.
 * <P>
 * Usage: java -Dpj.np=<I>K</I> Program1Clu
 * <BR><I>K</I> = Number of parallel processes
 *
 * @author  Alan Kaminsky
 * @version 14-Sep-2007
 */
public class Program1Clu
	{

// Prevent construction.

	private Program1Clu()
		{
		}

// Exported operations.

	/**
	 * Main program.
	 */
	public static void main
		(String[] args)
		throws Exception
		{
		long t1 = System.currentTimeMillis();
		Comm.init (args);
		Comm world = Comm.world();
		int size = world.size();
		int rank = world.rank();
		long t2 = System.currentTimeMillis();
		int x = rank + 1;
		multiply (x);
		long t3 = System.currentTimeMillis();
		System.out.println
			("x = "+x+" call start = "+(t2-t1)+" msec");
		System.out.println
			("x = "+x+" call finish = "+(t3-t1)+" msec");
		}

// Hidden operations.

	/**
	 * Subroutine for one computation. Multiplies its argument by 500 million.
	 */
	private static int multiply
		(int x)
		{
		int y = 0;
		for (int i = 1; i <= 500000000; ++ i) y += x;
		return y;
		}

	}
