#!/bin/sh

# This is kind of like a mini autoconf configure script.
# I have nothing against a real autoconf configure script,
# but I have yet to figure out how to make one.
# -Dave

    #######################################################################

if [ "$#" != "3" ]; then
	echo "this should only be run from make"
	exit 1
fi

INC_DIRS="/usr/include /usr/local/include $HOME/include"

echo -n "checking for gtk+ (required) "
FOUNDGTK="`gtk-config --version`"
if [ -n "$FOUNDGTK" ]; then
 GTKVER="`echo $FOUNDGTK' ' | tr . ' '`"
 GTK_MAJOR_VERSION="`echo $GTKVER | awk '{print $1;}'`"
 GTK_MINOR_VERSION="`echo $GTKVER | awk '{print $2;}'`"
 GTK_MICRO_VERSION="`echo $GTKVER | awk '{print $3;}'`"
 if (test $GTK_MAJOR_VERSION -lt 1); then
  FOUNDGTK=""
 else
  echo "found GTK+ $GTK_MAJOR_VERSION.$GTK_MINOR_VERSION.$GTK_MICRO_VERSION"
 fi
fi
if [ -z "$FOUNDGTK" ]; then
  echo "not found."
  echo "You need GTK installed to compile $1"
  echo "For more information on GTK, see http://www.gtk.org/"
  exit 1
fi

FOUNDGNOME=""
if [ -z "$NOGNOME" ]; then
 echo -n "checking for gnome >= 1.0 (optional) ... "
 FOUNDGNOME="`gnome-config --version`"
 if [ -n "$FOUNDGNOME" ]; then
  GNOMEVER="`echo $FOUNDGNOME' ' | sed s/gnome-libs//g | tr . ' '`"
  GNOME_MAJOR_VERSION="`echo $GNOMEVER | awk '{print $1;}'`"
  GNOME_MINOR_VERSION="`echo $GNOMEVER | awk '{print $2;}'`"
  if (test $GNOME_MAJOR_VERSION -lt 1); then
	FOUNDGNOME=""
  fi
 fi
 if [ -n "$FOUNDGNOME" ]; then
	echo "found gnome $GNOME_MAJOR_VERSION.$GNOME_MINOR_VERSION"
 else
	echo "not found";
	FOUNDGNOME=""
 fi
fi

echo -n "checking for joystick (optional) "
JOYSTICK=""
for d in $INC_DIRS; do
	echo -n "... "
	if [ -f "$d/linux/joystick.h" ]; then JOYSTICK=1; break; fi
done
if [ -n "$JOYSTICK" ]; then echo " found"
else echo "not found"
fi

if [ -n "$FOUNDGNOME" ]; then
	echo -n "checking for esd (optional) "
	FOUNDESD=""
	for d in $INC_DIRS; do
		echo -n "... "
		if [ -f "$d/esd.h" ]; then FOUNDESD=1; break; fi
	done
	if [ -n "$FOUNDESD" ]; then echo " found"
	else echo "not found"
	fi
fi

echo -n "checking for zlib (optional) "
FOUNDZLIB=""
for d in $INC_DIRS; do
	echo -n "... "
	if [ -f "$d/zlib.h" ]; then FOUNDZLIB=1; break; fi
done
if [ -n "$FOUNDZLIB" ]; then
	echo " found"
	LIBZ="-lz"
else
	echo "not found"
	LIBZ=""
fi

### Create config.h

cat <<EOF> config.h
/* This file was generated by $0 */
#ifndef S9X_CONFIG_H
#define S9X_CONFIG_H
#define PROG "$1"
#define VER "$2"
#define REL "$3"
#ifndef GTK_MAJOR_VERSION
#define GTK_MAJOR_VERSION $GTK_MAJOR_VERSION
#define GTK_MINOR_VERSION $GTK_MINOR_VERSION
#define GTK_MICRO_VERSION $GTK_MICRO_VERSION
#endif
#define FR_GTK "gtk $GTK_MAJOR_VERSION.$GTK_MINOR_VERSION.$GTK_MICRO_VERSION"
EOF
if [ -n "$JOYSTICK" ]; then
	echo "#define S9X_INCLUDE_JOYSTICK" >> config.h
fi
if [ -n "$FOUNDZLIB" ]; then
	echo "#define S9X_INCLUDE_ZLIB" >> config.h
fi
if [ -n "$FOUNDGNOME" ]; then
	echo "#undef FR_GNOME" >> config.h
	echo "#define FR_GNOME \"$FOUNDGNOME\"" >> config.h
	if [ "$FOUNDESD" != "" ]; then
		echo "#define S9X_INCLUDE_ESD 1" >> config.h
	fi
fi
echo "#endif" >> config.h

### Specify the default install directory for the snes9express binary
echo "/usr/local/bin" > install.dir

if [ "$FOUNDGNOME" != "" ]; then
	CFLAGS="-DFR_GNOME `gnome-config --cflags glib gtk gnomeui`"
	LIBS="`gnome-config --libs glib gtk gnomeui`"
else
	CFLAGS="`gtk-config --cflags`"
	LIBS="`gtk-config --libs` $LIBZ"
fi
export CFLAGS LIBS
### Create the flags for the appropriate interface:
cat <<EOF > frend-config
#!/bin/sh

if [ "\$1" = "--cflags" ]; then
	echo "$CFLAGS"
elif [ "\$1" = "--libs" ]; then
	echo "$LIBS"
else
	echo "\$0 usage: \$0 [--cflags|--libs]" 1>&2
fi
EOF
