#ifndef S9X_JOYSTICK_H
#define S9X_JOYSTICK_H

#include "defines.h"
#include "frend.h"

#define S9X_JS_COUNT 4

class s9x_Joystick;

class s9x_JoyMap : 	public fr_Option, private fr_Listener {
 private:
   int			Index, Row, SelectedBtn, axes, buttons;
   int			device_fd, device_id;
   bool			IsVisible;
   char			JSname[40];
   fr_DataTable&	MapTable;
   void			SetBtn(int btn, int val);
   int			GetBtn(int btn);
   void			EventOccurred(fr_Event*e);
 public:
			s9x_JoyMap(s9x_Joystick*parent, int j, fr_DataTable& m);
   void			SetToDefault();
   bool			IsDefault();
   void			SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			SetSelectedBtnVal(int val);
   int			GetSelectedBtnVal();
   void			SelectColumn(int col);
   void			MoveSelector(int dir);
   void			AlterSelectedBtn(int dir);
   int			OpenDevice(char*dev);
   void			CloseDevice();
};

class s9x_Joystick :    public fr_Notepage, private fr_Listener {
   friend s9x_JoyMap;
 private:
   fr_Window		DevWindow, MapWindow;
   fr_File		devJS0, devJS1, devJS2, devJS3, *devJS[S9X_JS_COUNT];
   fr_Button		DevBtn, DevClose, MapBtn, MapCloseBtn;
   fr_PulldownMenu	Buttons;
   fr_Checkbox		Old, UseJoystick, Swap;
   fr_Label		MapDiagram, MapInstructions;
   fr_DataTable		MapTable;
   fr_Image		ImgInd, ImgX;
   fr_ButtonBox		MapButtonBox;
   s9x_JoyMap		Map0, Map1, Map2, Map3, *Map[S9X_JS_COUNT];
   void			SetTableSelection();
 public:
   			s9x_Joystick(fr_Element*parant);
   void			SetToDefaults();
   void			Set9xVersion(float version);
   void			SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			EventOccurred(fr_Event*e);
};

#endif
