/*
 * snes9express
 * cpu.cc
 * Copyright  1998  David Nordlund
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * For further details, please read the included COPYING file,
 * or go to http://www.gnu.org/copyleft/gpl.html
 */

#include "cpu.h"

s9x_CPU::s9x_CPU(fr_Notebook*parent):
s9x_Notepage(parent, "CPU"),
HDMA(this, "H-DMA", true),
SpeedHacks(this, "Speed-Hacks", true),
SuperFX(this, "SuperFX", true),
DSP1(this, "DSP1", true),
Cycles(this, "Cycles:", fr_Horizontal, 100, 0, 200, 0, true)
{
   SetGridSize(4, 2, false);

   HDMA.Args << fr_CaseInsensitive << "-hdma" << "-ha";
   HDMA.NotArgs << fr_CaseInsensitive << "-nohdma" << "-nh";
   HDMA.SetKeyStroke("0");
   HDMA.SetTooltip("Use H-DMA emulation");
   Pack(HDMA);
   addOption(HDMA);
   
   SpeedHacks.Args << fr_CaseInsensitive << "-speedhacks" << "-SH";
   SpeedHacks.NotArgs << fr_CaseInsensitive << "-nospeedhacks";
   SpeedHacks.SetTooltip("Use some speed-up shortcuts.  These can "
			 "occasionally cause problems with certain ROMs");
   Pack(SpeedHacks);
   addOption(SpeedHacks);

   SuperFX.Args << fr_CaseInsensitive << "-sfx" << "-superfx";
   SuperFX.NotArgs << fr_CaseInsensitive << "-nosfx" << "-nosuperfx";
   SuperFX.SetTooltip("Allow emulation of the SuperFX chip");
   Pack(SuperFX);
   addOption(SuperFX);

   DSP1.Args << fr_CaseInsensitive << "-dsp1";
   DSP1.NotArgs << fr_CaseInsensitive << "-nodsp1";
   DSP1.SetTooltip("Allow emulation of the DSP1 chip");
   Pack(DSP1);
   addOption(DSP1);

   Cycles.Args << fr_CaseInsensitive << "-cycles" << "-h";
   Cycles.SetTooltip("The percent of CPU cycles to execute per scan line.  Lower is faster, but too low may cause some ROMs not to work");
   Pack(Cycles, 0, 1, 2, 2);
   addOption(Cycles);
}

void s9x_CPU::Set9xVersion(float version)
{
	DSP1.EnableIf(version >= 1.05);
}

void s9x_CPU::EventOccurred(fr_Event*e)
{
}
