package tijmp.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import tijmp.ProfilerHandler;
import tijmp.ui.Translator;

/** A class to show all instances of a class.
 */
public class ShowAllInstances extends AbstractAction {
    private ProfilerHandler ph;
    private Class<?> clz;
    
    public ShowAllInstances (ProfilerHandler ph, Class<?> clz) {
	super ("Show all instances of " + Translator.translate (clz));
	this.ph = ph;
	this.clz = clz;
    }
    
    public void actionPerformed (ActionEvent e) {
	ph.submitTask (new Runnable () {
		public void run () {
		    ph.showInstances (clz);
		}
	    });
    }    
}
