package tijmp.filter;

import tijmp.ui.Translator;

/** A filter that only matches classes in a package or its sub packages
 */
public class RecursiveFilter implements Filter {
    private String prefix;

    public RecursiveFilter (String prefix) {
	if (prefix == null)
	    throw new IllegalArgumentException ("null is not a valid prefix");
	this.prefix = prefix;
    }

    public boolean accept (Class<?> c) {
	if (c == null)
	    return false;
	String hrn = Translator.translate (c);
	return hrn.startsWith (prefix);
    }
}
