/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public boolean canTraverseOutsideSubtree() {
        if (this.m_patterns != null) {
            int n = this.m_patterns.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.m_patterns[n2].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n = this.m_patterns.length;
        int n2 = 0;
        while (n2 < n) {
            XObject xObject2 = this.m_patterns[n2].execute(xPathContext);
            if (xObject2 != NodeTest.SCORE_NONE) {
                if (xObject == null) {
                    xObject = xObject2;
                } else if (xObject2.num() > xObject.num()) {
                    xObject = xObject2;
                }
            }
            ++n2;
        }
        if (xObject == null) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
    }
}

