-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001-3  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Text_IO;
with Interfaces.C;
with Misc;         use Misc;

package body Echo is

   pragma Linker_Options("ada-echo-c.o");

   function C_Set_Echo return Interfaces.C.int;

   pragma Import(C, C_Set_Echo, "setecho");

   function C_No_Echo return Interfaces.C.int;

   pragma Import(C, C_No_Echo, "noecho");

   procedure Set_Echo is
      Result : Interfaces.C.Int;
      use type Interfaces.C.Int;
   begin
      Debug("Setting echo; input will be echoed");
      Result := C_Set_Echo;
      if Result /= 0 then
         raise Operation_Failed;
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Set_Echo");
         raise;
   end Set_Echo;

   procedure Clear_Echo is
      Result : Interfaces.C.Int;
      use type Interfaces.C.Int;
   begin
      Debug("Clearing echo; no input will be echoed");
      Result := C_No_Echo;
      if Result /= 0 then
         raise Operation_Failed;
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Echo.Clear_Echo");
         raise;
   end Clear_Echo;

end Echo;
