-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001-2003  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Characters.Latin_1;
with Ada.Strings.Unbounded;
with Ada.Text_IO;
with Expanding_Array;

pragma Elaborate_All(Expanding_Array);

package Globals is

   -- Initial number of keys to be associated.
   Initial_KL : constant Positive := 300;

   Not_Implemented : exception;

   -- Some renamings of unbounded strings.
   subtype UBS is Ada.Strings.Unbounded.Unbounded_String;

   function ToUBS(S : String) return UBS
     renames Ada.Strings.Unbounded.To_Unbounded_String;

   function ToStr(U : UBS) return String
     renames Ada.Strings.Unbounded.To_String;

   -- We will want to play with arrays of UBS.
   type UBS_Array is array (Integer range <>) of UBS;

   -- Pointers to UBS arrays.
   type UBS_Array_Pointer is access UBS_Array;

   -- We also want expanding arrays....
   package UBS_Array_Package is new Expanding_Array (Item => UBS);
   package UAP renames UBS_Array_Package;
   subtype UBS_Big_Array is UAP.Big_Array;

   -- Want to insert line feeds in some strings.
   NL : constant String    := Ada.Characters.Latin_1.LF & "";

   -- The result file stuff.
   Result_File : Ada.Text_IO.File_Type;

   -- What is our process ID?  (Needed for tempfiles.)
   Our_PID : Integer;

   -- Our home directory.
   Topal_Directory : UBS;

   -- Configuration data types.
   type Config_Record is
      record
         My_Key : UBS;
         Chmod_Binary,
           Clear_Binary,
           Date_Binary,
           Diff_Binary,
           Dos2Unix_Binary,
           Formail_Binary,
           Gpg_Binary,
           Grep_Binary,
           Less_Binary,
           Md5sum_Binary,
           Metamail_Binary,
           Mimeconstruct_Binary,
           Mkdir_Binary,
           Mv_Binary,
           Rm_Binary,
           Sed_Binary,
           Stty_Binary,
           Tee_Binary,
           Test_Binary
           : UBS;
         General_Options,
           Gpg_Options,
           Receiving_Options,
           Sending_Options : UBS;

         --  decrypt-not-cached: 1 always, 2 ask, 3 never
         --  decrypt-not-cached-use-cache: 1 always, 2 ask, 3 never
         --  decrypt-cached: 1 always, 2 ask, 3 never
         --  decrypt-cached-use-cache: 1 use, 2 again-replace,
         --                            3 again-ask-replace,
         --                            4 again-never, 5 offer

         --  Ditto for verify-not-cached, verify-not-cached-use-cache,
         --  verify-cached, verify-cached-use-Cache
         Decrypt_Not_Cached,
           Decrypt_Not_Cached_Use_Cache,
           Decrypt_Cached,
           Decrypt_Cached_Use_Cache,
           Verify_Not_Cached,
           Verify_Not_Cached_Use_Cache,
           Verify_Cached,
           Verify_Cached_Use_Cache : Positive;
         Decrypt_Cached_Fast_Continue,
           Verify_Cached_Fast_Continue,
           Verify_Not_Cached_Fast_Continue,
           FE_Simple,
           Inline_Separate_Output,
           No_Clean, -- Not preserved in config file.
           Debug : Boolean;
         -- A list of keys to be associated with email addresses.
         AKE_Key : UBS_Big_Array;
         AKE_Email : UBS_Big_Array;
         AKE_Count : Natural;
         -- A list of keys to be excluded from the key list.
         XK_Key : UBS_Big_Array;
         XK_Count : Natural;
      end record;

   Config : Config_Record;

end Globals;
