/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jsp;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class WLJspc
extends MatchingTask {
    private File destinationDirectory;
    private File sourceDirectory;
    private String destinationPackage;
    private Path compileClasspath;
    private String pathToPackage = "";
    private Vector filesToDo = new Vector();

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(((Task)this).project);
        }
        return this.compileClasspath;
    }

    public void execute() throws BuildException {
        if (!this.destinationDirectory.isDirectory()) {
            throw new BuildException("destination directory " + this.destinationDirectory.getPath() + " is not valid");
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new BuildException("src directory " + this.sourceDirectory.getPath() + " is not valid");
        }
        if (this.destinationPackage == null) {
            throw new BuildException("package attribute must be present.", ((Task)this).location);
        }
        String systemClassPath = System.getProperty("java.class.path");
        this.pathToPackage = this.destinationPackage.replace('.', File.separatorChar);
        DirectoryScanner ds = super.getDirectoryScanner(this.sourceDirectory);
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(((Task)this).project);
        }
        this.compileClasspath.append(Path.systemClasspath);
        String[] files = ds.getIncludedFiles();
        Java helperTask = (Java)((Task)this).project.createTask("java");
        helperTask.setFork(true);
        helperTask.setClassname("weblogic.jspc");
        helperTask.setTaskName(this.getTaskName());
        String[] args = new String[12];
        File jspFile = null;
        String parents = "";
        String arg = "";
        int j = 0;
        args[j++] = "-d";
        args[j++] = this.destinationDirectory.getAbsolutePath().trim();
        args[j++] = "-docroot";
        args[j++] = this.sourceDirectory.getAbsolutePath().trim();
        args[j++] = "-keepgenerated";
        args[j++] = "-compilerclass";
        args[j++] = "sun.tools.javac.Main";
        args[j++] = "-classpath";
        args[j++] = this.compileClasspath.toString();
        this.scanDir(files);
        this.log("Compiling " + this.filesToDo.size() + " JSP files");
        int i = 0;
        while (i < this.filesToDo.size()) {
            jspFile = new File((String)this.filesToDo.elementAt(i));
            args[j] = "-package";
            parents = jspFile.getParent();
            if (parents != null && !"".equals(parents)) {
                parents = this.replaceString(parents, File.separator, "_.");
                args[j + 1] = String.valueOf(this.destinationPackage) + "." + "_" + parents;
            } else {
                args[j + 1] = this.destinationPackage;
            }
            args[j + 2] = String.valueOf(String.valueOf(this.sourceDirectory)) + File.separator + (String)this.filesToDo.elementAt(i);
            arg = "";
            int x = 0;
            while (x < 12) {
                arg = String.valueOf(arg) + " " + args[x];
                ++x;
            }
            System.out.println("arg = " + arg);
            helperTask.clearArgs();
            helperTask.setArgs(arg);
            helperTask.setClasspath(this.compileClasspath);
            if (helperTask.executeJava() != 0) {
                this.log(String.valueOf(files[i]) + " failed to compile", 1);
            }
            ++i;
        }
    }

    protected String replaceString(String inpString, String escapeChars, String replaceChars) {
        String localString = "";
        int numTokens = 0;
        StringTokenizer st = new StringTokenizer(inpString, escapeChars, true);
        numTokens = st.countTokens();
        int i = 0;
        while (i < numTokens) {
            String test = st.nextToken();
            test = test.equals(escapeChars) ? replaceChars : test;
            localString = String.valueOf(localString) + test;
            ++i;
        }
        return localString;
    }

    protected void scanDir(String[] files) {
        long now = new Date().getTime();
        File jspFile = null;
        String parents = null;
        String pack = "";
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(this.sourceDirectory, files[i]);
            jspFile = new File(files[i]);
            parents = jspFile.getParent();
            boolean loc = false;
            if (parents != null && !"".equals(parents)) {
                parents = this.replaceString(parents, File.separator, "_/");
                pack = String.valueOf(this.pathToPackage) + File.separator + "_" + parents;
            } else {
                pack = this.pathToPackage;
            }
            String filePath = String.valueOf(pack) + File.separator + "_";
            int startingIndex = files[i].lastIndexOf(File.separator) != -1 ? files[i].lastIndexOf(File.separator) + 1 : 0;
            int endingIndex = files[i].indexOf(".jsp");
            if (endingIndex == -1) break;
            filePath = String.valueOf(filePath) + files[i].substring(startingIndex, endingIndex);
            filePath = String.valueOf(filePath) + ".class";
            File classFile = new File(this.destinationDirectory, filePath);
            if (srcFile.lastModified() > now) {
                this.log("Warning: file modified in the future: " + files[i], 1);
            }
            if (srcFile.lastModified() > classFile.lastModified()) {
                this.filesToDo.addElement(files[i]);
                this.log("Recompiling File " + files[i], 3);
            }
            ++i;
        }
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setDest(File dirName) {
        this.destinationDirectory = dirName;
    }

    public void setPackage(String packageName) {
        this.destinationPackage = packageName;
    }

    public void setSrc(File dirName) {
        this.sourceDirectory = dirName;
    }
}

