/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc.fesi;

import FESI.Data.ArrayPrototype;
import FESI.Data.DatePrototype;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import helma.xmlrpc.XmlRpc;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FesiRpcUtil {
    public static Object convertE2J(ESValue eSValue) throws EcmaScriptException {
        if (XmlRpc.debug) {
            System.out.println("converting e-2-j: " + eSValue.getClass());
        }
        if (eSValue instanceof ESNull) {
            return null;
        }
        if (eSValue instanceof ArrayPrototype) {
            ArrayPrototype arrayPrototype = (ArrayPrototype)eSValue;
            int n = arrayPrototype.size();
            Vector<Object> vector = new Vector<Object>();
            int n2 = 0;
            while (n2 < n) {
                Object object = FesiRpcUtil.convertE2J(arrayPrototype.getProperty(n2));
                vector.addElement(object);
                ++n2;
            }
            return vector;
        }
        if (eSValue instanceof ObjectPrototype) {
            ObjectPrototype objectPrototype = (ObjectPrototype)eSValue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Enumeration enumeration = objectPrototype.getProperties();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (XmlRpc.debug) {
                    System.out.println("converting object member " + string);
                }
                if ((object = FesiRpcUtil.convertE2J(objectPrototype.getProperty(string, string.hashCode()))) == null) continue;
                hashtable.put(string, object);
            }
            return hashtable;
        }
        if (eSValue instanceof ESUndefined || eSValue instanceof ESNull) {
            return null;
        }
        Object object = eSValue.toJavaObject();
        if (object instanceof Byte || object instanceof Short) {
            object = new Integer(object.toString());
        }
        return object;
    }

    public static ESValue convertJ2E(Object object, Evaluator evaluator) throws Exception {
        if (object == null) {
            return ESNull.theNull;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            ArrayPrototype arrayPrototype = new ArrayPrototype(evaluator.getArrayPrototype(), evaluator);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                arrayPrototype.putProperty(n2, FesiRpcUtil.convertJ2E(vector.elementAt(n2), evaluator));
                ++n2;
            }
            return arrayPrototype;
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            ObjectPrototype objectPrototype = new ObjectPrototype(evaluator.getObjectPrototype(), evaluator);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                objectPrototype.putProperty(string, FesiRpcUtil.convertJ2E(hashtable.get(string), evaluator), string.hashCode());
            }
            return objectPrototype;
        }
        if (object instanceof String) {
            return new ESString(object.toString());
        }
        if (object instanceof Number) {
            return new ESNumber(new Double(object.toString()).doubleValue());
        }
        if (object instanceof Boolean) {
            return ESBoolean.makeBoolean((boolean)((Boolean)object));
        }
        if (object instanceof Date) {
            return new DatePrototype(evaluator, (Date)object);
        }
        return ESLoader.normalizeValue((Object)object, (Evaluator)evaluator);
    }
}

