/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.BrokerRequest;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.broker.BrokerInitException;
import org.webmacro.broker.Config;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceManager;
import org.webmacro.broker.ResourceMap;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceRevokedException;
import org.webmacro.broker.TestProvider;
import org.webmacro.util.Log;

public final class ResourceBroker
implements Broker {
    static final int REQUEST_ = 0;
    static final int CREATE_ = 1;
    static final int DELETE_ = 2;
    static final boolean debug_ = false;
    static final Log _log = new Log("broker", "resource broker package");
    private static final long _DEFAULT_EXPIRE = 30000L;
    private final Hashtable _managers = new Hashtable();
    private boolean _shutdown = false;

    public ResourceBroker() throws BrokerInitException {
        this(new Config());
    }

    public ResourceBroker(String string) throws BrokerInitException {
        this(new Config(string));
    }

    public ResourceBroker(Config config) throws BrokerInitException {
        String string;
        this.join(config);
        try {
            string = (String)this.getValue("config", "Providers");
        }
        catch (NotFoundException notFoundException) {
            throw new BrokerInitException("Could not read list of providers out of the configuration file; the configuration file appears to have incomplete data.");
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new BrokerInitException("Could not read configuration data at all; the broker failed to initialize correctly.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            try {
                Class<?> clazz = Class.forName(string2);
                ResourceProvider resourceProvider = (ResourceProvider)clazz.newInstance();
                this.join(resourceProvider);
                _log.info("Loaded provider: " + string2);
            }
            catch (Exception exception) {
                _log.exception(exception);
                _log.error("Could not load resource provider \"" + string2 + "\":" + exception);
            }
        }
    }

    public final synchronized void join(ResourceProvider resourceProvider) {
        if (this._shutdown) {
            return;
        }
        try {
            resourceProvider.init(this);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.warning("Could not initialize listener: " + resourceProvider);
            try {
                resourceProvider.destroy();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
        String[] stringArray = resourceProvider.getTypes();
        int n = 0;
        while (n < stringArray.length) {
            ResourceManager resourceManager = (ResourceManager)this._managers.get(stringArray[n]);
            if (null == resourceManager) {
                resourceManager = new ResourceManager(this, stringArray[n]);
                this._managers.put(stringArray[n], resourceManager);
            }
            resourceManager.addListener(resourceProvider);
            ++n;
        }
    }

    public final synchronized void leave(ResourceProvider resourceProvider) {
        String[] stringArray = resourceProvider.getTypes();
        int n = 0;
        while (n < stringArray.length) {
            ResourceManager resourceManager = (ResourceManager)this._managers.get(stringArray[n]);
            if (null != resourceManager) {
                resourceManager.removeListener(resourceProvider);
            }
            ++n;
        }
    }

    public Object getValue(String string, String string2) throws NotFoundException, InvalidTypeException {
        int n = 0;
        while (n < 100) {
            try {
                BrokerRequest brokerRequest = this.request(string, string2);
                return brokerRequest.getValue();
            }
            catch (ResourceRevokedException resourceRevokedException) {
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    throw new NotFoundException("Thread interrupted.");
                }
                ++n;
            }
        }
        throw new NotFoundException("Resource locked by revoker.");
    }

    public final ResourceMap get(String string) throws InvalidTypeException {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(string);
        if (resourceManager == null || !resourceManager.isProvider()) {
            throw new InvalidTypeException("No provider for " + string);
        }
        return resourceManager;
    }

    public final BrokerRequest request(String string, String string2) throws InvalidTypeException, NotFoundException {
        return this.locate(string, string2, null, 0, true);
    }

    public final BrokerRequest request(String string, String string2, boolean bl) throws InvalidTypeException, NotFoundException {
        return this.locate(string, string2, null, 0, true);
    }

    public final BrokerRequest delete(String string, String string2) throws InvalidTypeException, NotFoundException {
        return this.locate(string, string2, null, 2, true);
    }

    public final BrokerRequest create(String string, String string2, Object object) throws InvalidTypeException, NotFoundException {
        return this.locate(string, string2, object, 1, true);
    }

    public final BrokerRequest create(String string, String string2) throws InvalidTypeException, NotFoundException {
        return this.locate(string, string2, null, 1, true);
    }

    public final void revoke(ResourceEvent resourceEvent) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(resourceEvent.getType());
        if (resourceManager == null) {
            _log.error("Attempt to revoke resource with no manager: " + resourceEvent);
            return;
        }
        resourceManager.revoke(resourceEvent, "Resource revoked by request");
    }

    public final boolean isProvider(String string) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(string);
        if (resourceManager == null) {
            return false;
        }
        return resourceManager.isProvider();
    }

    public final void shutdown() {
        ResourceManager resourceManager;
        ResourceBroker resourceBroker = this;
        synchronized (resourceBroker) {
            this._shutdown = true;
        }
        Enumeration enumeration = this._managers.elements();
        while (enumeration.hasMoreElements()) {
            resourceManager = (ResourceManager)enumeration.nextElement();
            resourceManager.shutdownResources();
        }
        Hashtable hashtable = new Hashtable();
        enumeration = this._managers.elements();
        while (enumeration.hasMoreElements()) {
            resourceManager = (ResourceManager)enumeration.nextElement();
            resourceManager.shutdownListeners(hashtable);
        }
    }

    private ResourceEvent locate(String string, String string2, Object object, int n, boolean bl) throws InvalidTypeException, NotFoundException {
        try {
            return ((ResourceManager)this._managers.get(string)).locate(string2, object, n, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidTypeException("No such type: " + string);
        }
    }

    final void blocked(ResourceEvent resourceEvent) throws NotFoundException {
        try {
            ((ResourceManager)this._managers.get(resourceEvent.getType())).blocked(resourceEvent);
        }
        catch (NullPointerException nullPointerException) {
            throw new NotFoundException("No provider for " + resourceEvent);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"type one"};
            String[] stringArray3 = new String[]{"type two"};
            String[] stringArray4 = new String[]{"type three", "type two"};
            System.out.println("MAIN: Creating new broker with 5sec expire time");
            ResourceBroker resourceBroker = new ResourceBroker();
            TestProvider testProvider = new TestProvider(stringArray2, "provider 1", "A");
            TestProvider testProvider2 = new TestProvider(stringArray3, "provider 2", "B");
            TestProvider testProvider3 = new TestProvider(stringArray4, "provider 3", "C");
            resourceBroker.join(testProvider);
            resourceBroker.join(testProvider2);
            resourceBroker.join(testProvider3);
            System.out.println("MAIN: launching a lot of threads");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            System.out.println("MAIN1 Requesting type one/A:");
            ResourceEvent resourceEvent = (ResourceEvent)resourceBroker.request("type one", "A");
            System.out.println("MAIN1 request gave: " + resourceEvent);
            System.out.println("MAIN2 Requesting type two/B:");
            ResourceEvent resourceEvent2 = (ResourceEvent)resourceBroker.request("type two", "B");
            System.out.println("MAIN2 request gave: " + resourceEvent2);
            ResourceEvent resourceEvent3 = null;
            try {
                System.out.println("MAIN3: Requesting type four/B:");
                resourceEvent3 = (ResourceEvent)resourceBroker.request("type four", "B");
                System.out.println("ERROR: should not have got here");
            }
            catch (InvalidTypeException invalidTypeException) {
                System.out.println("Got expected exception (no type four provider)");
            }
            System.out.println("MAIN4: Requesting type two/D:");
            ResourceEvent resourceEvent4 = (ResourceEvent)resourceBroker.request("type two", "D");
            System.out.println("MAIN4 request gave: " + resourceEvent4);
            System.out.println("MAIN1: " + resourceEvent + " = " + resourceEvent.getValue());
            System.out.println("MAIN2: " + resourceEvent2 + " = " + resourceEvent2.getValue());
            try {
                System.out.println("MAIN4: " + resourceEvent4 + " = " + resourceEvent4.getValue());
            }
            catch (NotFoundException notFoundException) {
                System.out.println("Got expected excption: " + resourceEvent4 + " has no provider");
            }
            Thread.sleep(2500L);
            System.out.println("Touching " + resourceEvent);
            resourceEvent.update();
            Thread.sleep(2500L);
            System.out.println("Touching " + resourceEvent);
            resourceEvent.update();
            Thread.sleep(2500L);
            System.out.println("---SHUTDOWN---");
            resourceBroker.shutdown();
            System.out.println("---DONE---");
        }
        catch (Exception exception) {
            System.out.println("---UNEXPECTED EXCEPTION---");
            exception.printStackTrace();
        }
    }
}

